/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.internal.editor.handler.ControlGenerator;
import org.eclipse.emf.ecp.view.internal.editor.handler.SelectAttributesDialog;
import org.eclipse.emf.ecp.view.internal.editor.handler.SelectAttributesWizard;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.treemasterdetail.ui.swt.MasterDetailAction;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateControlsHandler
extends MasterDetailAction {
    private Set<EStructuralFeature> getFeaturesToCreate(SelectAttributesDialog sad) {
        Set<EStructuralFeature> features = sad.getSelectedFeatures();
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        LinkedHashSet<EStructuralFeature> featuresToAdd = new LinkedHashSet<EStructuralFeature>();
        IItemPropertyDescriptor propertyDescriptor = null;
        EClass rootClass = sad.getRootClass();
        for (EStructuralFeature feature : features) {
            if (rootClass.isAbstract() || rootClass.isInterface()) {
                featuresToAdd.add(feature);
                continue;
            }
            propertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)EcoreUtil.create((EClass)rootClass), (Object)feature);
            if (propertyDescriptor != null) {
                featuresToAdd.add(feature);
                continue;
            }
            this.logInvalidFeature(feature.getName(), sad.getRootClass().getName());
        }
        composedAdapterFactory.dispose();
        return featuresToAdd;
    }

    private void logInvalidFeature(String featureName, String eClassName) {
        String infoMessage = "Feature " + featureName + " of the class " + eClassName + "could not be rendered because it has no property descriptor.";
        ILog log = Activator.getDefault().getLog();
        log.log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.editor.controls", infoMessage));
    }

    public void execute(EObject object) {
        CallbackFeatureSupplier callBack = new CallbackFeatureSupplier(){

            @Override
            public Set<EStructuralFeature> get(VView view) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SelectAttributesDialog sad = new SelectAttributesDialog(new SelectAttributesWizard(), view, view.getRootEClass(), shell);
                int result = sad.open();
                if (result == 0) {
                    return GenerateControlsHandler.this.getFeaturesToCreate(sad);
                }
                return Collections.emptySet();
            }
        };
        this.execute(object, callBack);
    }

    void execute(final EObject vElement, CallbackFeatureSupplier featureSupplier) {
        if (!VView.class.isInstance(vElement) && !VContainer.class.isInstance(vElement)) {
            return;
        }
        VView view = this.getView(vElement);
        if (view == null) {
            return;
        }
        final EClass rootEClass = view.getRootEClass();
        final Set<EStructuralFeature> featuresToAdd = featureSupplier.get(view);
        if (featuresToAdd.isEmpty()) {
            return;
        }
        AdapterFactoryEditingDomain.getEditingDomainFor((EObject)view).getCommandStack().execute((Command)new ChangeCommand((Notifier)view){

            protected void doExecute() {
                ControlGenerator.addControls(rootEClass, (VElement)vElement, featuresToAdd);
            }
        });
    }

    private VView getView(EObject object) {
        while (!(object instanceof VView)) {
            if ((object = object.eContainer()) != null) continue;
            return null;
        }
        return (VView)object;
    }

    public boolean shouldShow(EObject object) {
        if (object == null) {
            return false;
        }
        return object instanceof VView || object instanceof VContainer;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selection = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (selection == null || !(selection instanceof EObject)) {
            return null;
        }
        this.execute((EObject)selection);
        return null;
    }

    static interface CallbackFeatureSupplier {
        public Set<EStructuralFeature> get(VView var1);
    }
}

