/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table.action;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.swt.table.action.Action;
import org.eclipse.emfforms.spi.swt.table.action.ActionBar;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfiguration;
import org.eclipse.emfforms.spi.swt.table.action.ActionControlCreator;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TableActionBar<V extends AbstractTableViewer>
implements ActionBar<V> {
    private final ActionConfiguration configuration;
    private final Map<String, Control> controls = new LinkedHashMap<String, Control>();

    public TableActionBar(ActionConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void fillComposite(Composite composite, V viewer) {
        for (Action action : this.configuration.getActions()) {
            if (!this.configuration.hasControlFor(action)) continue;
            ActionControlCreator<? extends Control> controlCreator = this.configuration.getControlCreator(action);
            Control control = controlCreator.createControl(composite, action);
            this.addControl(action.getId(), control);
        }
        this.applyLayout(composite);
    }

    protected void applyLayout(Composite composite) {
        GridLayoutFactory.fillDefaults().numColumns(this.getControlCount()).equalWidth(false).applyTo(composite);
    }

    protected Collection<Action> getActions() {
        return Collections.unmodifiableCollection(this.configuration.getActions());
    }

    protected void addControl(String id, Control control) {
        if (this.controls.containsKey(id)) {
            throw new IllegalArgumentException(MessageFormat.format("A control with id {0} already exists", id));
        }
        this.controls.put(id, control);
    }

    @Override
    public Optional<Control> getControlById(String id) {
        return Optional.ofNullable((Object)this.controls.get(id));
    }

    @Override
    public int getControlCount() {
        return this.controls.size();
    }

    @Override
    public int getActionCount() {
        return this.controls.size();
    }

    @Override
    public void updateActionBar() {
        for (Action action : this.configuration.getActions()) {
            boolean canExecute = false;
            try {
                canExecute = action.canExecute();
            }
            finally {
                Optional<Control> control = this.getControlById(action.getId());
                if (control.isPresent()) {
                    ((Control)control.get()).setEnabled(canExecute);
                }
            }
        }
    }
}

