/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.preview.common;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.IViewProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={IViewProvider.class, PreviewWorkspaceViewProvider.class})
public class PreviewWorkspaceViewProvider
implements IViewProvider {
    private final Map<IPath, VView> trackedPaths = new LinkedHashMap<IPath, VView>();
    private IResourceChangeListener viewResourceChangeListener;

    public PreviewWorkspaceViewProvider() {
        this.addViewResourceChangeListener();
    }

    private void addViewResourceChangeListener() {
        this.viewResourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (PreviewWorkspaceViewProvider.this.trackedPaths.isEmpty()) {
                    return;
                }
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    while (delta.getAffectedChildren().length != 0) {
                        delta = delta.getAffectedChildren()[0];
                    }
                    for (IPath path : PreviewWorkspaceViewProvider.this.trackedPaths.keySet()) {
                        if (!delta.getResource().getFullPath().equals((Object)path)) continue;
                        VView view = PreviewWorkspaceViewProvider.this.loadView(path);
                        PreviewWorkspaceViewProvider.this.trackedPaths.put(path, view);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.viewResourceChangeListener);
    }

    public void addViewModel(IPath path) {
        VView view = this.loadView(path);
        this.trackedPaths.put(path, view);
    }

    private VView loadView(IPath path) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)path.toOSString(), (boolean)true));
        try {
            resource.load(null);
            EObject eObject = (EObject)resource.getContents().get(0);
            if (!VView.class.isInstance(eObject)) {
                throw new IllegalArgumentException("The provided path " + path.toString() + " doesn't contain a VView.");
            }
            return (VView)eObject;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void removeViewModel(IPath path) {
        this.unloadView(path);
        this.trackedPaths.remove(path);
    }

    private void unloadView(IPath path) {
        VView view = this.trackedPaths.get(path);
        view.eResource().unload();
    }

    public double canProvideViewModel(EObject eObject, VViewModelProperties properties) {
        for (VView view : this.trackedPaths.values()) {
            if (!view.getRootEClass().equals(eObject.eClass())) continue;
            return 10.0;
        }
        return -1.0;
    }

    public VView provideViewModel(EObject eObject, VViewModelProperties properties) {
        for (VView view : this.trackedPaths.values()) {
            if (!view.getRootEClass().equals(eObject.eClass())) continue;
            return view;
        }
        return null;
    }

    @Deactivate
    public void dispose() {
        if (this.viewResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.viewResourceChangeListener);
        }
    }
}

