/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.view.table.ui.swt.persistedstate;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.internal.view.table.ui.swt.persistedstate.Activator;
import org.eclipse.emf.ecp.spi.view.table.ui.swt.persistedstate.PersistTableStateService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextDisposeListener;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.util.VViewResourceFactoryImpl;
import org.eclipse.emf.ecp.view.spi.model.util.VViewResourceImpl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableColumnConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VWidthConfiguration;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;

public class PersistTableStateServiceImpl
implements PersistTableStateService {
    private String viewID;
    private Set<VTableControl> tables;
    private LinkedHashSet<VControl> additionalControls;
    private URI uri;
    private VViewResourceImpl resource;
    private ReportService reportService;

    PersistTableStateServiceImpl(final ViewModelContext context) {
        this.reportService = (ReportService)context.getService(ReportService.class);
        context.registerDisposeListener(new ViewModelContextDisposeListener(){

            public void contextDisposed(ViewModelContext viewModelContext) {
                if (context != viewModelContext) {
                    return;
                }
                PersistTableStateServiceImpl.this.persist();
            }
        });
        VElement viewModel = context.getViewModel();
        this.viewID = viewModel.getUuid();
        if (this.viewID == null) {
            return;
        }
        this.tables = PersistTableStateServiceImpl.findTables(viewModel);
        this.additionalControls = new LinkedHashSet();
        String stateLocation = Activator.getInstance().getStateLocation().toFile().getAbsolutePath();
        this.uri = URI.createFileURI((String)stateLocation).appendSegment(this.viewID).appendFileExtension("xmi");
        ResourceSet resourceSet = PersistTableStateServiceImpl.createResourceSet();
        if (!resourceSet.getURIConverter().exists(this.uri, null)) {
            return;
        }
        this.resource = (VViewResourceImpl)resourceSet.getResource(this.uri, true);
        for (VTableControl realTable : this.tables) {
            Map<VDomainModelReference, VWidthConfiguration> realColumnDMRToConfig = PersistTableStateServiceImpl.getDMRToConfig(realTable);
            EObject persistedTable = (EObject)this.resource.getIDToEObjectMap().get(realTable.getUuid());
            if (!VTableControl.class.isInstance(persistedTable)) continue;
            VTableDomainModelReference realTableDMR = (VTableDomainModelReference)VTableDomainModelReference.class.cast(realTable.getDomainModelReference());
            Map<VDomainModelReference, VWidthConfiguration> persistedDMRIDToConfig = PersistTableStateServiceImpl.getDMRToConfig((VTableControl)VTableControl.class.cast(persistedTable));
            for (Map.Entry<VDomainModelReference, VWidthConfiguration> entry : persistedDMRIDToConfig.entrySet()) {
                VDomainModelReference realMatchingDMR = null;
                for (VDomainModelReference realDMR : realTableDMR.getColumnDomainModelReferences()) {
                    if (!EcoreUtil.equals((EObject)((EObject)entry.getKey()), (EObject)realDMR)) continue;
                    realMatchingDMR = realDMR;
                    break;
                }
                if (realMatchingDMR == null) continue;
                if (realColumnDMRToConfig.containsKey(realMatchingDMR)) {
                    PersistTableStateServiceImpl.fillWidthConfig(realColumnDMRToConfig.get(realMatchingDMR), entry.getValue());
                    continue;
                }
                VWidthConfiguration widthConfiguration = VTableFactory.eINSTANCE.createWidthConfiguration();
                PersistTableStateServiceImpl.fillWidthConfig(widthConfiguration, entry.getValue());
                widthConfiguration.setColumnDomainReference(realMatchingDMR);
                realTable.getColumnConfigurations().add((Object)widthConfiguration);
            }
        }
    }

    private static void fillWidthConfig(VWidthConfiguration toFill, VWidthConfiguration lookup) {
        toFill.setWeight(lookup.getWeight());
        toFill.setMinWidth(lookup.getMinWidth());
    }

    private static Map<VDomainModelReference, VWidthConfiguration> getDMRToConfig(VTableControl table) {
        LinkedHashMap<VDomainModelReference, VWidthConfiguration> result = new LinkedHashMap<VDomainModelReference, VWidthConfiguration>();
        for (VTableColumnConfiguration configuration : table.getColumnConfigurations()) {
            if (!VWidthConfiguration.class.isInstance(configuration)) continue;
            VWidthConfiguration widthConfiguration = (VWidthConfiguration)VWidthConfiguration.class.cast(configuration);
            result.put(widthConfiguration.getColumnDomainReference(), widthConfiguration);
        }
        return result;
    }

    private static ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("*", new VViewResourceFactoryImpl());
        return resourceSet;
    }

    private static Set<VTableControl> findTables(VElement viewModel) {
        LinkedHashSet<VTableControl> tables = new LinkedHashSet<VTableControl>();
        TreeIterator viewModelContents = viewModel.eAllContents();
        while (viewModelContents.hasNext()) {
            EObject next = (EObject)viewModelContents.next();
            if (!VTableControl.class.isInstance(next)) continue;
            tables.add((VTableControl)next);
        }
        return tables;
    }

    private void persist() {
        ResourceSet resourceSet = PersistTableStateServiceImpl.createResourceSet();
        VViewResourceImpl resource = (VViewResourceImpl)resourceSet.createResource(this.uri);
        for (VTableControl tableControl : this.tables) {
            String uuid = tableControl.getUuid();
            VTableControl tableToPersist = (VTableControl)EcoreUtil.copy((EObject)tableControl);
            resource.getContents().add((Object)tableToPersist);
            resource.setID((EObject)tableToPersist, uuid);
        }
        block3: for (VControl control : this.additionalControls) {
            for (VAttachment attachment : control.getAttachments()) {
                if (!PersistTableStateService.PersistTableStateServiceVAttachment.class.isInstance(attachment)) continue;
                String uuid = control.getUuid();
                VAttachment attachmentToPersist = (VAttachment)EcoreUtil.copy((EObject)attachment);
                resource.getContents().add((Object)attachmentToPersist);
                resource.setID((EObject)attachmentToPersist, uuid);
                continue block3;
            }
        }
        try {
            resource.save(null);
        }
        catch (IOException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex));
        }
    }

    @Override
    public void registerAdditionalControls(VControl ... controls) {
        VControl[] vControlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            VControl control = vControlArray[n2];
            if (!this.tables.contains(control)) {
                this.additionalControls.add(control);
            }
            ++n2;
        }
    }

    @Override
    public Optional<VAttachment> getPersistedState(VControl control) {
        String uuid = control.getUuid();
        EObject eObject = (EObject)this.resource.getIDToEObjectMap().get(uuid);
        if (!VAttachment.class.isInstance(eObject)) {
            return Optional.empty();
        }
        return Optional.of((Object)((VAttachment)VAttachment.class.cast(eObject)));
    }
}

