/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPPropertiesAware;
import org.eclipse.emf.ecp.core.util.observer.ECPPropertiesObserver;
import org.eclipse.emf.ecp.internal.core.util.Element;
import org.eclipse.emf.ecp.internal.core.util.Properties;
import org.eclipse.emf.ecp.internal.core.util.PropertiesStore;

public abstract class PropertiesElement
extends Element
implements PropertiesStore.StorableElement,
ECPPropertiesAware {
    private final ECPProperties properties;
    private ECPPropertiesObserver observer;

    public PropertiesElement(String name, ECPProperties properties) {
        super(name);
        this.properties = properties;
        this.observeProperties();
    }

    public PropertiesElement(ObjectInput in) throws IOException {
        super(in.readUTF());
        this.properties = new Properties(in);
        this.observeProperties();
    }

    @Override
    public void write(ObjectOutput out) throws IOException {
        out.writeUTF(this.getName());
        ((Properties)this.properties).write(out);
    }

    @Override
    public final ECPProperties getProperties() {
        return this.properties;
    }

    protected void propertiesChanged(Collection<Map.Entry<String, String>> oldProperties, Collection<Map.Entry<String, String>> newProperties) {
    }

    private void observeProperties() {
        if (this.observer != null) {
            this.cleanup();
        }
        this.observer = new ECPPropertiesObserver(){

            @Override
            public void propertiesChanged(ECPProperties properties, Collection<Map.Entry<String, String>> oldProperties, Collection<Map.Entry<String, String>> newProperties) {
                PropertiesElement.this.propertiesChanged(oldProperties, newProperties);
            }
        };
        this.properties.addObserver(this.observer);
    }

    protected void cleanup() {
        if (this.properties == null || this.observer == null) {
            return;
        }
        this.properties.removeObserver(this.observer);
    }
}

