/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.ChildrenDescriptorCollector;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.util.ECPCheckoutSource;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.core.util.Disposable;
import org.eclipse.emf.ecp.internal.core.util.Element;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.composites.PropertiesComposite;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.util.ECPDisposable;
import org.eclipse.emf.ecp.spi.ui.CompositeStateObserver;
import org.eclipse.emf.ecp.spi.ui.UIProvider;
import org.eclipse.emf.ecp.spi.ui.util.ECPHandlerHelper;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DefaultUIProvider
extends Element
implements UIProvider {
    private static final String PROJECT_OPEN_ICON = "icons/project_open.gif";
    private static final String PROJECT_CLOSED_ICON = "icons/project_closed.gif";
    private static final String REPOSITORY_ICON = "icons/repository.gif";
    private static final String UNKNOWN_PACKAGE_ICON = "icons/EPackageUnknown.gif";
    private static final String EPACKAGE_ICON = "icons/EPackage.gif";
    private final Disposable disposable = new Disposable((ECPDisposable)this){

        protected void doDispose() {
            DefaultUIProvider.this.doDispose();
        }
    };
    private String label;
    private String description;

    public DefaultUIProvider(String name) {
        super(name);
        this.label = name;
        this.description = "";
    }

    public String getType() {
        return "UIProvider";
    }

    @Override
    public InternalProvider getProvider() {
        return (InternalProvider)ECPUtil.getECPProviderRegistry().getProvider(this.getName());
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
        return null;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public final boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    public final void dispose() {
        this.disposable.dispose();
    }

    public final void addDisposeListener(ECPDisposable.DisposeListener listener) {
        this.disposable.addDisposeListener(listener);
    }

    public final void removeDisposeListener(ECPDisposable.DisposeListener listener) {
        this.disposable.removeDisposeListener(listener);
    }

    protected void doDispose() {
    }

    @Override
    public String getText(Object element) {
        if (element instanceof Resource) {
            Resource resource = (Resource)element;
            return resource.getURI().lastSegment();
        }
        return UIProvider.EMF_LABEL_PROVIDER.getText(element);
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof ECPProject) {
            ECPProject project = (ECPProject)element;
            return project.isOpen() ? Activator.getImage(PROJECT_OPEN_ICON) : Activator.getImage(PROJECT_CLOSED_ICON);
        }
        if (element instanceof ECPRepository) {
            return Activator.getImage(REPOSITORY_ICON);
        }
        return UIProvider.EMF_LABEL_PROVIDER.getImage(element);
    }

    @Override
    public void fillContextMenu(IMenuManager manager, ECPContainer context, Object[] elements) {
        if (elements.length == 1) {
            Object element = elements[0];
            if (context instanceof ECPProject) {
                this.fillContextMenuForProject(manager, (ECPProject)context, element);
            }
        }
    }

    private void fillContextMenuForProject(IMenuManager manager, ECPProject project, Object element) {
        if (!(element instanceof Resource)) {
            if (element instanceof EObject) {
                EditingDomain domain = project.getEditingDomain();
                ChildrenDescriptorCollector childrenDescriptorCollector = new ChildrenDescriptorCollector();
                Collection descriptors = childrenDescriptorCollector.getDescriptors((EObject)element);
                if (descriptors != null) {
                    this.fillContextMenuWithDescriptors(manager, descriptors, domain, element, project);
                }
            } else if (element instanceof ItemProviderAdapter && ((ItemProviderAdapter)element).getTarget() instanceof EObject) {
                EditingDomain domain = project.getEditingDomain();
                ItemProviderAdapter adapter = (ItemProviderAdapter)element;
                element = adapter.getTarget();
                Collection descriptors = adapter.getNewChildDescriptors(element, domain, null);
                this.fillContextMenuWithDescriptors(manager, descriptors, domain, element, project);
            }
        }
    }

    private void fillContextMenuWithDescriptors(IMenuManager manager, Collection<?> descriptors, final EditingDomain domain, Object object, final ECPProject project) {
        if (!EObject.class.isInstance(object)) {
            return;
        }
        final EObject eObject = (EObject)object;
        for (Object descriptor : descriptors) {
            CommandParameter cp;
            if (!CommandParameter.class.isInstance(descriptor) || (cp = (CommandParameter)descriptor).getEReference() == null || !cp.getEReference().isMany() && eObject.eIsSet(cp.getEStructuralFeature()) || cp.getEReference().isMany() && cp.getEReference().getUpperBound() != -1 && cp.getEReference().getUpperBound() <= ((List)eObject.eGet((EStructuralFeature)cp.getEReference())).size()) continue;
            manager.add((IAction)new CreateChildAction(domain, (ISelection)new StructuredSelection((Object)eObject), descriptor){

                public void run() {
                    super.run();
                    EReference reference = ((CommandParameter)this.descriptor).getEReference();
                    if (!reference.isContainment()) {
                        domain.getCommandStack().execute(AddCommand.create((EditingDomain)domain, (Object)eObject.eContainer(), null, (Object)cp.getEValue()));
                    }
                    domain.getCommandStack().execute(AddCommand.create((EditingDomain)domain, (Object)eObject, (Object)reference, (Object)cp.getEValue()));
                    ECPHandlerHelper.openModelElement(cp.getEValue(), project);
                }
            });
        }
    }

    @Override
    public Control createAddRepositoryUI(Composite parent, ECPProperties repositoryProperties, Text repositoryNameText, Text repositoryLabelText, Text repositoryDescriptionText) {
        return new PropertiesComposite(parent, true, repositoryProperties);
    }

    @Override
    public Control createCheckoutUI(Composite parent, ECPCheckoutSource checkoutSource, ECPProperties projectProperties) {
        return new PropertiesComposite(parent, true, projectProperties);
    }

    @Override
    public Control createNewProjectUI(Composite parent, CompositeStateObserver observer, ECPProperties projectProperties) {
        return null;
    }

    protected boolean populateNewRoot(Resource resource, IMenuManager manager) {
        boolean populated = false;
        EPackage.Registry packageRegistry = EPackage.Registry.INSTANCE;
        Map.Entry<String, Object>[] entryArray = DefaultUIProvider.getSortedRegistryEntries(packageRegistry);
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<String, Object> entry = entryArray[n2];
            IContributionItem item = DefaultUIProvider.populateSubMenu(resource, entry.getKey(), entry.getValue(), packageRegistry);
            if (item != null) {
                manager.add(item);
                populated = true;
            }
            ++n2;
        }
        return populated;
    }

    private static IContributionItem populateSubMenu(final Resource resource, String nsURI, Object value, final EPackage.Registry packageRegistry) {
        if (value instanceof EPackage) {
            EPackage ePackage = (EPackage)value;
            ImageDescriptor imageDescriptor = Activator.getImageDescriptor(EPACKAGE_ICON);
            MenuManager submenuManager = new MenuManager(nsURI, imageDescriptor, nsURI);
            DefaultUIProvider.populateSubMenu(resource, ePackage, submenuManager);
            return submenuManager;
        }
        ImageDescriptor imageDescriptor = Activator.getImageDescriptor(UNKNOWN_PACKAGE_ICON);
        final MenuManager submenuManager = new MenuManager(nsURI, imageDescriptor, nsURI);
        submenuManager.setRemoveAllWhenShown(true);
        submenuManager.add((IAction)new Action(Messages.DefaultUIProvider_Calculating){});
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                String nsURI = submenuManager.getMenuText();
                EPackage ePackage = packageRegistry.getEPackage(nsURI);
                if (ePackage != null) {
                    DefaultUIProvider.populateSubMenu(resource, ePackage, submenuManager);
                } else {
                    Activator.log(MessageFormat.format(Messages.DefaultUIProvider_CantFindInPackageRegistry, nsURI));
                }
            }
        });
        return submenuManager;
    }

    private static void populateSubMenu(final Resource resource, EPackage ePackage, MenuManager submenuManager) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || eClass.isInterface()) continue;
            objects.add(EcoreUtil.create((EClass)eClass));
        }
        if (!objects.isEmpty()) {
            Collections.sort(objects, new Comparator<EObject>(){

                @Override
                public int compare(EObject o1, EObject o2) {
                    return o1.eClass().getName().compareTo(o2.eClass().getName());
                }
            });
            for (final EObject object : objects) {
                String text = object.eClass().getName();
                Image image = UIProvider.EMF_LABEL_PROVIDER.getImage((Object)object);
                ImageDescriptor imageDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor((Object)image);
                Action action = new Action(text, imageDescriptor){

                    public void run() {
                        resource.getContents().add((Object)object);
                        try {
                            resource.save(Collections.singletonMap("ENCODING", "UTF-8"));
                        }
                        catch (IOException ex) {
                            Activator.log(ex);
                        }
                    }
                };
                submenuManager.add((IAction)action);
            }
        }
    }

    private static Map.Entry<String, Object>[] getSortedRegistryEntries(EPackage.Registry packageRegistry) {
        Set entries = packageRegistry.entrySet();
        Map.Entry[] array = entries.toArray(new Map.Entry[entries.size()]);
        Arrays.sort(array, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return array;
    }
}

