/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.renderer.fx;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.controls.internal.fx.Activator;
import org.eclipse.emf.ecp.controls.internal.fx.ManyAttributesObservableList;
import org.eclipse.emf.ecp.view.model.internal.fx.SimpleControlRendererFX;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emfforms.spi.common.report.ReportService;

public class StringListRendererFX
extends SimpleControlRendererFX {
    public StringListRendererFX(VControl vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    protected Node createControl() {
        VControl control = (VControl)this.getVElement();
        final EStructuralFeature.Setting setting = (EStructuralFeature.Setting)control.getDomainModelReference().getIterator().next();
        VBox vBox = new VBox();
        Button addBtn = new Button("Add");
        addBtn.setMaxWidth(Double.MAX_VALUE);
        addBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                StringListRendererFX.this.addItem(setting);
            }
        });
        vBox.getChildren().add((Object)addBtn);
        ListView listView = new ListView();
        VBox.setMargin((Node)listView, (Insets)new Insets(0.0));
        listView.setItems(new ManyAttributesObservableList(setting.getEObject(), setting.getEStructuralFeature()));
        listView.setEditable(true);
        listView.setCellFactory((Callback)new Callback<ListView<Object>, ListCell<Object>>(){

            public ListCell<Object> call(ListView<Object> list) {
                return new ListCell<Object>(){

                    public void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        if (item != null) {
                            Label tf = new Label();
                            tf.setText(item.toString());
                            this.setGraphic((Node)tf);
                        }
                    }

                    public void cancelEdit() {
                        Label tf = new Label();
                        tf.setText(this.getListValue().toString());
                        this.setGraphic((Node)tf);
                    }

                    public void commitEdit(Object value) {
                        List objects = (List)setting.get(false);
                        objects.set(this.getIndex(), value);
                        this.cancelEdit();
                    }

                    public void startEdit() {
                        final TextField textField = new TextField();
                        textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                                if (!newValue.booleanValue()) {
                                    this.commitEdit(textField.getText());
                                }
                            }
                        });
                        textField.setText((String)this.getListValue());
                        this.setGraphic((Node)textField);
                        this.setText(null);
                        textField.selectPositionCaret(0);
                    }

                    private Object getListValue() {
                        return ((List)setting.get(false)).get(this.getIndex());
                    }

                    public void updateSelected(boolean selected) {
                        super.updateSelected(selected);
                    }
                };
            }
        });
        vBox.getChildren().add((Object)listView);
        this.applyValidation(control, (Node)listView);
        return vBox;
    }

    protected void addItem(EStructuralFeature.Setting setting) {
        Object defaultValue = setting.getEStructuralFeature().getEType().getDefaultValue();
        if (defaultValue == null) {
            try {
                defaultValue = setting.getEStructuralFeature().getEType().getInstanceClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                Activator.logException(e);
            }
            catch (IllegalAccessException e) {
                Activator.logException(e);
            }
            catch (IllegalArgumentException e) {
                Activator.logException(e);
            }
            catch (InvocationTargetException e) {
                Activator.logException(e);
            }
            catch (NoSuchMethodException e) {
                Activator.logException(e);
            }
            catch (SecurityException e) {
                Activator.logException(e);
            }
        }
        ((List)setting.get(true)).add(defaultValue);
    }
}

