/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.internal.fx;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.emf.ecp.view.model.common.AbstractRenderer;
import org.eclipse.emf.ecp.view.model.internal.fx.GridCellFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFX;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;

public abstract class RendererFX<VELEMENT extends VElement>
extends AbstractRenderer<VELEMENT> {
    private Map<GridCellFX, Node> nodes;

    public void init(VELEMENT vElement, ViewModelContext viewContext) {
        if (this.getVElement() != null) {
            return;
        }
        super.init(vElement, viewContext);
        this.nodes = new LinkedHashMap<GridCellFX, Node>();
    }

    public abstract GridDescriptionFX getGridDescription();

    public Node render(GridCellFX cell) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Node node = this.nodes.get((Object)cell);
        if (node != null) {
            return node;
        }
        node = this.renderNode(cell);
        if (node == null) {
            return null;
        }
        this.nodes.put(cell, node);
        return node;
    }

    protected abstract Node renderNode(GridCellFX var1) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption;

    protected final Map<GridCellFX, Node> getNodes() {
        if (this.nodes == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap<GridCellFX, Node>(this.nodes);
    }
}

