/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.internal.property.ExpectedListChangedEventConstraint;
import org.eclipse.platform.discovery.util.internal.property.ExpectedSingleListChangedEventConstraint;
import org.eclipse.platform.discovery.util.internal.property.IListProperty;
import org.eclipse.platform.discovery.util.internal.property.IListPropertyListener;
import org.eclipse.platform.discovery.util.internal.property.ListChangeListenerMaintainer;
import org.eclipse.platform.discovery.util.internal.property.NotifyingList;
import org.eclipse.platform.discovery.util.internal.property.PropertyListChangedEvent;
import org.jmock.core.Constraint;

public class NotifyingListTests
extends MockObjectTestCase {
    private Mock<List<Object>> mockDelegateList;
    private Mock<ListIterator<Object>> mockDelegateIterator;
    private Mock<IListProperty<Object>> mockProperty;
    private Mock<IListPropertyListener<Object>> mockListener;
    private Set<IListPropertyListener<Object>> listeners;
    private NotifyingList<Object> target;
    private final Object[] readWrite = new Object[]{new Object(), new Object(), new Object()};

    public void setUp() {
        this.mockDelegateIterator = this.mock(ListIterator.class);
        this.mockDelegateList = this.mock(List.class);
        this.mockDelegateList.stubs().method("toArray").will(this.returnValue(this.readWrite));
        this.mockDelegateList.stubs().method("size").withNoArguments().will(this.returnValue(this.readWrite.length));
        this.mockDelegateList.stubs().method("iterator").withNoArguments().will(this.returnValue(this.mockDelegateIterator.proxy()));
        this.mockDelegateList.stubs().method("listIterator").withNoArguments().will(this.returnValue(this.mockDelegateIterator.proxy()));
        this.mockDelegateList.stubs().method("listIterator").with((Constraint)this.eq(0)).will(this.returnValue(this.mockDelegateIterator.proxy()));
        this.mockProperty = this.mock(IListProperty.class);
        this.mockListener = this.mock(IListPropertyListener.class);
        this.mockListener.stubs().method("hashCode").will(this.returnValue(26));
        this.mockListener.stubs().method("equals").with((Constraint)this.same(this.mockListener.proxy())).will(this.returnValue(true));
        this.listeners = new HashSet<IListPropertyListener<Object>>();
        this.listeners.add((IListPropertyListener<Object>)((IListPropertyListener)this.mockListener.proxy()));
        this.target = new NotifyingList((List)this.mockDelegateList.proxy(), (ListChangeListenerMaintainer)new ListenerMaintainerImpl());
    }

    public void testAddIndex() {
        this.mockDelegateList.expects(this.once()).method("add").with((Constraint)this.eq(26), (Constraint)this.same(this.readWrite[0]));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, this.readWrite[0]));
        this.target.add(26, this.readWrite[0]);
    }

    public void testAdd() {
        this.mockDelegateList.expects(this.once()).method("add").with((Constraint)this.same(this.readWrite[0])).will(this.returnValue(true));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, this.readWrite[0]));
        NotifyingListTests.assertTrue((boolean)this.target.add(this.readWrite[0]));
    }

    public void testAddAll() {
        List<Object> toAdd = Arrays.asList(this.readWrite);
        this.mockDelegateList.expects(this.once()).method("addAll").with((Constraint)this.same(toAdd)).will(this.returnValue(true));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, toAdd));
        NotifyingListTests.assertTrue((boolean)this.target.addAll(toAdd));
    }

    public void testAddAllIndex() {
        List<Object> toAdd = Arrays.asList(this.readWrite);
        this.mockDelegateList.expects(this.once()).method("addAll").with((Constraint)this.eq(26), (Constraint)this.same(toAdd)).will(this.returnValue(true));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, toAdd));
        NotifyingListTests.assertTrue((boolean)this.target.addAll(26, toAdd));
    }

    public void testClear() {
        this.mockDelegateList.expects(this.once()).method("clear").withNoArguments();
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, Arrays.asList(this.readWrite)));
        this.target.clear();
    }

    public void testContains() {
        this.mockDelegateList.expects(this.once()).method("contains").with((Constraint)this.same(this.readWrite[0])).will(this.returnValue(true));
        NotifyingListTests.assertTrue((boolean)this.target.contains(this.readWrite[0]));
    }

    public void testContainsAll() {
        List<Object> contains = Arrays.asList(this.readWrite);
        this.mockDelegateList.expects(this.once()).method("containsAll").with((Constraint)this.eq(Arrays.asList(this.readWrite))).will(this.returnValue(true));
        NotifyingListTests.assertTrue((boolean)this.target.containsAll(contains));
    }

    public void testGet() {
        this.mockDelegateList.expects(this.once()).method("get").with((Constraint)this.eq(26)).will(this.returnValue(this.readWrite[0]));
        NotifyingListTests.assertSame((Object)this.readWrite[0], (Object)this.target.get(26));
    }

    public void testIndexOf() {
        this.mockDelegateList.expects(this.once()).method("indexOf").with((Constraint)this.eq(this.readWrite[0])).will(this.returnValue(26));
        NotifyingListTests.assertEquals((int)26, (int)this.target.indexOf(this.readWrite[0]));
    }

    public void testLastIndexOf() {
        this.mockDelegateList.expects(this.once()).method("lastIndexOf").with((Constraint)this.eq(this.readWrite[0])).will(this.returnValue(26));
        NotifyingListTests.assertEquals((int)26, (int)this.target.lastIndexOf(this.readWrite[0]));
    }

    public void testIsEmpty() {
        this.mockDelegateList.expects(this.once()).method("isEmpty").withNoArguments().will(this.returnValue(true));
        NotifyingListTests.assertTrue((boolean)this.target.isEmpty());
    }

    public void testIterator() {
        NotifyingListTests.assertEquals((String)"org.eclipse.platform.discovery.util.internal.property.NotifyingList$NotifyingListIterator", (String)this.target.iterator().getClass().getName());
    }

    public void testListIterator() {
        NotifyingListTests.assertEquals((String)"org.eclipse.platform.discovery.util.internal.property.NotifyingList$NotifyingListIterator", (String)this.target.listIterator().getClass().getName());
    }

    public void testListIteratorIndex() {
        NotifyingListTests.assertEquals((String)"org.eclipse.platform.discovery.util.internal.property.NotifyingList$NotifyingListIterator", (String)this.target.listIterator(0).getClass().getName());
    }

    public void testRemoveIndex() {
        this.mockDelegateList.expects(this.once()).method("remove").with((Constraint)this.eq(26)).will(this.returnValue(this.readWrite[0]));
        this.mockDelegateList.stubs().method("get").with((Constraint)this.eq(26)).will(this.returnValue(this.readWrite[0]));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, this.readWrite[0]));
        NotifyingListTests.assertSame((Object)this.readWrite[0], (Object)this.target.remove(26));
    }

    public void testRemove() {
        this.mockDelegateList.expects(this.once()).method("remove").with((Constraint)this.same(this.readWrite[0])).will(this.returnValue(true));
        this.mockDelegateList.stubs().method("contains").with((Constraint)this.same(this.readWrite[0])).will(this.returnValue(true));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, this.readWrite[0]));
        NotifyingListTests.assertSame((Object)true, (Object)this.target.remove(this.readWrite[0]));
    }

    public void testRemoveAll() {
        List<Object> reallyRemoved = Arrays.asList(this.readWrite).subList(0, 2);
        ArrayList<Object> toRemoveAll = new ArrayList<Object>(reallyRemoved);
        toRemoveAll.add(new Object());
        toRemoveAll.add(new Object());
        this.mockDelegateList.expects(this.once()).method("removeAll").with((Constraint)this.same(toRemoveAll)).will(this.returnValue(true));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, reallyRemoved));
        NotifyingListTests.assertTrue((boolean)this.target.removeAll(toRemoveAll));
    }

    public void testRetainAll() {
        List<Object> reallyRemoved = Arrays.asList(this.readWrite).subList(0, 2);
        ArrayList<Object> toRetainAll = new ArrayList<Object>(Arrays.asList(this.readWrite).subList(2, 3));
        toRetainAll.add(new Object());
        toRetainAll.add(new Object());
        this.mockDelegateList.expects(this.once()).method("retainAll").with((Constraint)this.same(toRetainAll)).will(this.returnValue(true));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, reallyRemoved));
        NotifyingListTests.assertTrue((boolean)this.target.retainAll(toRetainAll));
    }

    public void testSet() {
        Object toSet = new Object();
        this.mockDelegateList.expects(this.once()).method("set").with((Constraint)this.eq(1), (Constraint)this.same(toSet)).will(this.returnValue(this.readWrite[1]));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, this.readWrite[1]));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, toSet));
        NotifyingListTests.assertSame((Object)this.readWrite[1], (Object)this.target.set(1, toSet));
    }

    public void testSize() {
        this.mockDelegateList.expects(this.once()).method("size").withNoArguments().will(this.returnValue(26));
        NotifyingListTests.assertEquals((int)26, (int)this.target.size());
    }

    public void testSubList() {
        List<Object> subList = Arrays.asList(this.readWrite);
        this.mockDelegateList.expects(this.once()).method("subList").with((Constraint)this.eq(1), (Constraint)this.eq(2)).will(this.returnValue(subList));
        NotifyingListTests.assertSame(subList, (Object)this.target.subList(1, 2));
    }

    public void testToArray() {
        this.mockDelegateList.expects(this.once()).method("toArray").withNoArguments().will(this.returnValue(this.readWrite));
        NotifyingListTests.assertSame((Object)this.readWrite, (Object)this.target.toArray());
    }

    public void testListIteratorAdd() {
        this.mockDelegateIterator.expects(this.once()).method("add").with((Constraint)this.same(this.readWrite[0]));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, this.readWrite[0]));
        this.target.listIterator().add(this.readWrite[0]);
    }

    public void testListIteratorHasNext() {
        this.mockDelegateIterator.expects(this.once()).method("hasNext").withNoArguments().will(this.returnValue(true));
        NotifyingListTests.assertTrue((boolean)this.target.listIterator().hasNext());
    }

    public void testIteratorHasPrevious() {
        this.mockDelegateIterator.expects(this.once()).method("hasPrevious").withNoArguments().will(this.returnValue(true));
        NotifyingListTests.assertTrue((boolean)this.target.listIterator().hasPrevious());
    }

    public void testIteratorNext() {
        this.mockDelegateIterator.expects(this.once()).method("next").withNoArguments().will(this.returnValue(this.readWrite[0]));
        NotifyingListTests.assertSame((Object)this.readWrite[0], this.target.listIterator().next());
    }

    public void testIteratorPrevious() {
        this.mockDelegateIterator.expects(this.once()).method("previous").withNoArguments().will(this.returnValue(this.readWrite[0]));
        NotifyingListTests.assertSame((Object)this.readWrite[0], this.target.listIterator().previous());
    }

    public void testIteratorNextIndex() {
        this.mockDelegateIterator.expects(this.once()).method("nextIndex").withNoArguments().will(this.returnValue(26));
        NotifyingListTests.assertEquals((int)26, (int)this.target.listIterator().nextIndex());
    }

    public void previousIndex() {
        this.mockDelegateIterator.expects(this.once()).method("previousIndex").withNoArguments().will(this.returnValue(26));
        NotifyingListTests.assertEquals((int)26, (int)this.target.listIterator().previousIndex());
    }

    public void testIteratorRemoveAfterPrevious() {
        this.mockDelegateIterator.stubs().method("previous").withNoArguments().will(this.returnValue(this.readWrite[0]));
        this.mockDelegateIterator.expects(this.once()).method("remove").withNoArguments().id("callToRemove");
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, this.readWrite[0])).after(this.mockDelegateIterator, "callToRemove");
        ListIterator targetIterator = this.target.listIterator();
        NotifyingListTests.assertSame((Object)this.readWrite[0], targetIterator.previous());
        targetIterator.remove();
    }

    public void testIteratorRemoveAfterNext() {
        this.mockDelegateIterator.expects(this.once()).method("next").withNoArguments().will(this.returnValue(this.readWrite[0]));
        this.mockDelegateIterator.expects(this.once()).method("remove").withNoArguments().id("callToRemove");
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, this.readWrite[0])).after(this.mockDelegateIterator, "callToRemove");
        ListIterator targetIterator = this.target.listIterator();
        NotifyingListTests.assertSame((Object)this.readWrite[0], targetIterator.next());
        targetIterator.remove();
    }

    public void testIteratorRemoveAfterSet() {
        ListIterator targetIterator = this.target.listIterator();
        this.testIteratorSet(targetIterator);
        this.mockDelegateIterator.expects(this.once()).method("remove").withNoArguments().id("callToRemove");
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, this.readWrite[1])).after(this.mockDelegateIterator, "callToRemove");
        targetIterator.remove();
    }

    public void testIteratorSet() {
        ListIterator targetIterator = this.target.listIterator();
        this.testIteratorSet(targetIterator);
    }

    private void testIteratorSet(ListIterator<Object> targetIterator) {
        this.mockDelegateIterator.expects(this.once()).method("set").with((Constraint)this.same(this.readWrite[1])).id("callToSet");
        this.mockDelegateIterator.expects(this.once()).method("next").withNoArguments().will(this.returnValue(this.readWrite[0]));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, this.readWrite[0])).after(this.mockDelegateIterator, "callToSet");
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)((IListProperty)this.mockProperty.proxy()), PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, this.readWrite[1])).after(this.mockDelegateIterator, "callToSet");
        NotifyingListTests.assertSame((Object)this.readWrite[0], (Object)targetIterator.next());
        targetIterator.set(this.readWrite[1]);
    }

    private class ListenerMaintainerImpl
    implements ListChangeListenerMaintainer<Object> {
        private ListenerMaintainerImpl() {
        }

        public void fireEvent(PropertyListChangedEvent.ChangeKind kind, Collection<? extends Object> elements) {
            PropertyListChangedEvent event = new PropertyListChangedEvent((IListProperty)NotifyingListTests.this.mockProperty.proxy(), kind, elements);
            this.fireEvent((PropertyListChangedEvent<Object>)event);
        }

        public void fireSingleEvent(PropertyListChangedEvent.ChangeKind kind, Object element) {
            PropertyListChangedEvent event = new PropertyListChangedEvent((IListProperty)NotifyingListTests.this.mockProperty.proxy(), kind, Arrays.asList(element));
            this.fireEvent((PropertyListChangedEvent<Object>)event);
        }

        private void fireEvent(PropertyListChangedEvent<Object> event) {
            for (IListPropertyListener l : NotifyingListTests.this.listeners) {
                l.listChanged(event);
            }
        }
    }
}

