/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class ForkInUiProgressMonitor
implements IProgressMonitor {
    protected abstract IProgressMonitor delegate();

    private IProgressMonitor forkingDelegate(boolean synchronous) {
        DelegatingInvocationHandler handler = new DelegatingInvocationHandler(this.delegate(), synchronous);
        return (IProgressMonitor)Proxy.newProxyInstance(this.delegate().getClass().getClassLoader(), new Class[]{IProgressMonitor.class}, (InvocationHandler)handler);
    }

    public void beginTask(String name, int totalWork) {
        this.forkingDelegate(false).beginTask(name, totalWork);
    }

    public void done() {
        this.forkingDelegate(false).done();
    }

    public void internalWorked(double work) {
        this.forkingDelegate(false).internalWorked(work);
    }

    public boolean isCanceled() {
        return this.forkingDelegate(true).isCanceled();
    }

    public void setCanceled(boolean value) {
        this.forkingDelegate(false).setCanceled(value);
    }

    public void setTaskName(String name) {
        this.forkingDelegate(false).setTaskName(name);
    }

    public void subTask(String name) {
        this.forkingDelegate(false).subTask(name);
    }

    public void worked(int work) {
        this.forkingDelegate(false).worked(work);
    }

    private class DelegatingInvocationHandler
    implements InvocationHandler {
        private IProgressMonitor pm;
        private final boolean synchronous;

        public DelegatingInvocationHandler(IProgressMonitor pm, boolean synchronous) {
            this.pm = pm;
            this.synchronous = synchronous;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object[] resultHolder = new Object[1];
            Runnable runnable = this.invocationRunnable(method, args, resultHolder);
            if (Display.getCurrent() == null) {
                this.execInUi(runnable);
            } else {
                runnable.run();
            }
            return resultHolder[0];
        }

        private void execInUi(Runnable runnable) {
            if (this.synchronous) {
                PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
            }
        }

        private Runnable invocationRunnable(final Method method, final Object[] args, final Object[] resultHolder) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        resultHolder[0] = method.invoke((Object)DelegatingInvocationHandler.this.pm, args);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException(e);
                    }
                }
            };
        }
    }
}

