/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.tooltip;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TransformerHandler;
import org.eclipse.platform.discovery.ui.internal.tooltip.AbstractTooltipConfigurator;
import org.eclipse.platform.discovery.util.internal.xml.IXMLUtils;
import org.eclipse.platform.discovery.util.internal.xml.XMLUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FormTextBuilder
implements AbstractTooltipConfigurator.TooltipFormTextBuilder {
    private static final String EMPTY_STR = "";
    private static final String FORM_PREFIX = "form";
    private static final String PARAG_PREFIX = "p";
    private static final String BOLD_PREFIX = "b";
    private TransformerHandler transformerHandler;
    private StringWriter stringWriter;

    public FormTextBuilder() {
        try {
            this.stringWriter = new StringWriter();
            this.transformerHandler = this.xmlUtils().createTransformerHandler((Writer)this.stringWriter);
            this.transformerHandler.startDocument();
            this.transformerHandler.startElement(EMPTY_STR, EMPTY_STR, FORM_PREFIX, new AttributesImpl());
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    protected IXMLUtils xmlUtils() {
        return new XMLUtils();
    }

    @Override
    public void startParagraph(boolean appendVerticalSpace) {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute(EMPTY_STR, EMPTY_STR, "vspace", "CDATA", Boolean.toString(appendVerticalSpace));
        try {
            this.transformerHandler.startElement(EMPTY_STR, EMPTY_STR, PARAG_PREFIX, attr);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endParagraph() {
        try {
            this.transformerHandler.endElement(EMPTY_STR, EMPTY_STR, PARAG_PREFIX);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendBoldedText(String text) {
        try {
            this.transformerHandler.startElement(EMPTY_STR, EMPTY_STR, BOLD_PREFIX, new AttributesImpl());
            this.transformerHandler.characters(text.toCharArray(), 0, text.length());
            this.transformerHandler.endElement(EMPTY_STR, EMPTY_STR, BOLD_PREFIX);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendText(String text) {
        try {
            this.transformerHandler.characters(text.toCharArray(), 0, text.length());
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void endDocument() {
        try {
            this.transformerHandler.endElement(EMPTY_STR, EMPTY_STR, FORM_PREFIX);
            this.transformerHandler.endDocument();
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getText() {
        this.endDocument();
        return this.stringWriter.toString();
    }

    @Override
    public void appendProperty(String propertyName, String propertyValue) {
        this.startParagraph(false);
        this.appendBoldedText(propertyName);
        this.appendText(this.separator());
        this.appendText(propertyValue);
        this.endParagraph();
    }

    protected String separator() {
        return " ";
    }
}

