/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import org.eclipse.platform.discovery.ui.api.IFormTextBuilder;
import org.eclipse.platform.discovery.ui.internal.tooltip.AbstractTooltipConfigurator;
import org.eclipse.platform.discovery.ui.internal.tooltip.IToolTipConfigurator;
import org.eclipse.platform.discovery.ui.internal.tooltip.ToolTipConfigurator;
import org.eclipse.platform.discovery.ui.test.unit.internal.AbstractTooltipConfiguratorTest;
import org.jmock.core.Constraint;

public class ToolTipConfiguratorTest
extends AbstractTooltipConfiguratorTest {
    private static final String LINE1 = "line1";
    private static final String LINE2 = "line2";
    private static final String LINE3 = "line3";

    @Override
    protected IToolTipConfigurator createConfigurator() {
        return new ToolTipConfigurator(){

            protected String textContent() {
                return "line1\nline2\nline3";
            }

            protected AbstractTooltipConfigurator.TooltipFormTextBuilder createNewTooltipTextBuilder() {
                return ToolTipConfiguratorTest.this.createFormTextBuilderMock((IFormTextBuilder)ToolTipConfiguratorTest.this.textBuilder.proxy());
            }
        };
    }

    @Override
    public void testGetFormText() {
        this.textBuilder.expects(this.exactly(3)).method("startParagraph");
        this.textBuilder.expects(this.exactly(3)).method("endParagraph");
        this.textBuilder.expects(this.once()).method("appendText").with((Constraint)this.eq(LINE1));
        this.textBuilder.expects(this.once()).method("appendText").with((Constraint)this.eq(LINE2));
        this.textBuilder.expects(this.once()).method("appendText").with((Constraint)this.eq(LINE3));
        super.testGetFormText();
    }
}

