/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.internal.view.SearchFavoritesItemsAdder;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.jmock.core.Constraint;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class SearchFavoritesItemsAdderTest
extends MockObjectTestCase {
    private SearchFavoritesItemsAdder adder;
    private Mock<ISearchFavoritesViewCustomization> viewCustomization;
    private Mock<ILongOperationRunner> opRunner;
    private boolean itemsAreAdded;
    private Set<Object> expectedItemsToAdd;
    private Mock<IStructuredSelection> structuredSelection;

    protected void setUp() throws Exception {
        this.viewCustomization = this.mock(ISearchFavoritesViewCustomization.class);
        this.opRunner = this.mock(ILongOperationRunner.class);
        this.itemsAreAdded = false;
        this.expectedItemsToAdd = new HashSet<Object>();
        this.structuredSelection = this.mock(IStructuredSelection.class);
        ArrayList<ISearchFavoritesViewCustomization> customizations = new ArrayList<ISearchFavoritesViewCustomization>();
        customizations.add((ISearchFavoritesViewCustomization)this.viewCustomization.proxy());
        this.adder = new SearchFavoritesItemsAdder(customizations, (ILongOperationRunner)this.opRunner.proxy()){

            protected void doAddItems(Set<Object> items, ILongOperationRunner operationRunner) {
                SearchFavoritesItemsAdderTest.assertTrue((String)"Unexpected opRunner", (operationRunner == SearchFavoritesItemsAdderTest.this.opRunner.proxy() ? 1 : 0) != 0);
                SearchFavoritesItemsAdderTest.assertEquals((String)"Unexpected items", (Object)SearchFavoritesItemsAdderTest.this.expectedItemsToAdd, items);
                SearchFavoritesItemsAdderTest.this.itemsAreAdded = true;
            }
        };
    }

    public void testCanAddSelection_NonStructuredSelection() {
        SearchFavoritesItemsAdderTest.assertFalse((boolean)this.adder.canAddSelection((ISelection)this.mock(ISelection.class).proxy()));
    }

    public void testCanAddSelection_UnsupportedSelection() {
        Object sourceItem = new Object();
        this.viewCustomization.stubs().method("itemsFor").with((Constraint)this.eq(sourceItem)).will(this.returnValue(new HashSet()));
        this.setObjectsToSelection(new HashSet<Object>(Arrays.asList(sourceItem)));
        SearchFavoritesItemsAdderTest.assertFalse((boolean)this.adder.canAddSelection((ISelection)this.structuredSelection.proxy()));
    }

    public void testCanAddSelection_SupportedSelection() {
        Object sourceItem = new Object();
        Object bItem = new Object();
        this.viewCustomization.stubs().method("itemsFor").with((Constraint)this.eq(sourceItem)).will(this.returnValue(new HashSet<Object>(Arrays.asList(bItem))));
        this.setObjectsToSelection(new HashSet<Object>(Arrays.asList(sourceItem)));
        SearchFavoritesItemsAdderTest.assertTrue((boolean)this.adder.canAddSelection((ISelection)this.structuredSelection.proxy()));
    }

    public void testAddItems() {
        String sourceItem = "sourceItem";
        String bItem = "bItem";
        this.viewCustomization.stubs().method("itemsFor").with((Constraint)this.eq(sourceItem)).will(this.returnValue(new HashSet<Object>(Arrays.asList(bItem))));
        this.setObjectsToSelection(new HashSet<Object>(Arrays.asList(sourceItem)));
        this.expectedItemsToAdd.add(bItem);
        this.adder.addItems((ISelection)this.structuredSelection.proxy());
        SearchFavoritesItemsAdderTest.assertTrue((String)"Items are not added", (boolean)this.itemsAreAdded);
    }

    public void testAddItemsWithUnknownItems() {
        String sourceItem = "sourceItem";
        this.viewCustomization.stubs().method("itemsFor").with((Constraint)this.eq(sourceItem)).will(this.returnValue(new HashSet()));
        this.setObjectsToSelection(new HashSet<Object>(Arrays.asList(sourceItem)));
        try {
            this.adder.addItems((ISelection)this.structuredSelection.proxy());
            SearchFavoritesItemsAdderTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        SearchFavoritesItemsAdderTest.assertFalse((String)"Items are not added", (boolean)this.itemsAreAdded);
    }

    private void setObjectsToSelection(final Set<Object> objects) {
        this.structuredSelection.stubs().method("iterator").will(new Stub(){

            public Object invoke(Invocation arg0) throws Throwable {
                return objects.iterator();
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        });
    }
}

