/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.platform.discovery.runtime.api.IDisplayableObject;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.InteractiveComboSelectorPageObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class InteractiveComboSelectorTest {
    private static final String OBJECT1_LABEL = "Object1";
    private static final String OBJECT2_LABEL = "Object2";
    private IDisplayableObject object1;
    private IDisplayableObject object2;
    private List<IDisplayableObject> objectsSet;
    private InteractiveComboSelectorPageObject selector;

    @Before
    public void setUp() {
        this.object1 = this.mockDisplayableObject(OBJECT1_LABEL);
        this.object2 = this.mockDisplayableObject(OBJECT2_LABEL);
        this.objectsSet = new ArrayList<IDisplayableObject>();
        this.objectsSet.add(this.object1);
        this.objectsSet.add(this.object2);
        this.selector = new InteractiveComboSelectorPageObject(this.objectsSet);
        this.selector.open();
    }

    private IDisplayableObject mockDisplayableObject(String name) {
        IDisplayableObject dispObject = (IDisplayableObject)Mockito.mock(IDisplayableObject.class);
        Mockito.stub((Object)dispObject.getDisplayName()).toReturn((Object)name);
        return dispObject;
    }

    @After
    public void tearDown() {
        this.selector.close();
    }

    @Test
    public void testSelectorIsDisabledWhenEmptyInputIsSet() {
        Assert.assertTrue((String)"Selector should be enabled by default", (boolean)this.selector.isEnabled());
        this.selector.setInput(new ArrayList<IDisplayableObject>());
        Assert.assertFalse((String)"Selector should be disabled for empty input", (boolean)this.selector.isEnabled());
        this.selector.setInput(this.objectsSet);
        Assert.assertTrue((String)"Selector should be enabled", (boolean)this.selector.isEnabled());
    }

    @Test
    public void testSelectorPreservesSelectedItemOnSelectionChange() {
        this.selector.select(OBJECT2_LABEL);
        this.objectsSet.remove(this.object1);
        this.selector.setInput(this.objectsSet);
        Assert.assertEquals((String)"Unexpected object selected", (Object)OBJECT2_LABEL, (Object)this.selector.getSelection());
    }
}

