/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.ErrorHandlerPageObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ErrorHandlerTest {
    private static final String TITLE = "title";
    private static final String DETAILS = "details";
    private ErrorHandlerPageObject errorHandler;

    @Before
    public void setUp() {
        this.errorHandler = new ErrorHandlerPageObject();
    }

    @After
    public void tearDown() {
        if (this.errorHandler.isOpen()) {
            this.errorHandler.close();
        }
    }

    @Test
    public void showErrorMessage() {
        this.errorHandler.showError(TITLE, DETAILS);
        Assert.assertEquals((String)"Unexpected title", (Object)TITLE, (Object)this.errorHandler.getTitleShown());
        Assert.assertEquals((String)"Unexpected details", (Object)DETAILS, (Object)this.errorHandler.getDetailsShown());
        Assert.assertTrue((String)"Error message details text should be read only.", (boolean)this.errorHandler.isDetailsReadOnly());
    }

    @Test
    public void handleException() {
        Exception exception = new Exception("TGiF");
        this.errorHandler.handleException(exception, TITLE);
        Assert.assertEquals((String)"Unexpected title", (Object)TITLE, (Object)this.errorHandler.getTitleShown());
        this.errorHandler.getLogger().checkExceptionWasLogged(exception);
    }
}

