/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.test.unit.xpparser;

import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.destprefs.api.ISearchDestinationConfigurator;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.ISearchDestinationsConfiguratorDescription;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.SearchDestinationsConfiguratorXPParser;
import org.eclipse.platform.discovery.destprefs.test.unit.SearchConfiguratorsFixture;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.testutils.utils.testcases.AbstractExtensionPointParserTest;
import org.junit.Assert;

public class SearchDestinationsConfiguratorXPParserTest
extends AbstractExtensionPointParserTest<ISearchDestinationsConfiguratorDescription> {
    private SearchConfiguratorsFixture configuratorsFixture = new SearchConfiguratorsFixture();

    protected AbstractExtensionPointParser<ISearchDestinationsConfiguratorDescription> createParser(IExtensionRegistry registry) {
        return new SearchDestinationsConfiguratorXPParser(registry){

            protected ISearchProviderConfiguration searchProviderConfiguration() {
                return ((SearchDestinationsConfiguratorXPParserTest)SearchDestinationsConfiguratorXPParserTest.this).configuratorsFixture.searchProviderConfiguration;
            }
        };
    }

    protected void setupRegistry(ExtensionRegistryBuilder registryBuilder) {
        this.configuratorsFixture.setup(registryBuilder);
    }

    protected void verifyContributions(List<ISearchDestinationsConfiguratorDescription> contributions) {
        Assert.assertEquals((String)"3 contributions expected", (long)3L, (long)contributions.size());
        this.verifyConfigurator(this.configuratorsFixture.CATEGORY_1, this.configuratorsFixture.DEST_PROVIDER_CAT1_1, this.configuratorsFixture.CONFIGURATOR_1_1_FQNAME, this.configuratorsFixture.configurator_1_1, contributions);
        this.verifyConfigurator(this.configuratorsFixture.CATEGORY_1, this.configuratorsFixture.DEST_PROVIDER_CAT1_2, this.configuratorsFixture.CONFIGURATOR_1_2_FQNAME, this.configuratorsFixture.configurator_1_2, contributions);
        this.verifyConfigurator(this.configuratorsFixture.CATEGORY_2, this.configuratorsFixture.DEST_PROVIDER_CAT2, this.configuratorsFixture.CONFIGURATOR_2_FQNAME, this.configuratorsFixture.configurator_2, contributions);
    }

    private void verifyConfigurator(String destCategory, String destProviderId, String configuratorFQName, ISearchDestinationConfigurator<?> configurator, List<ISearchDestinationsConfiguratorDescription> contributions) {
        ISearchDestinationsConfiguratorDescription configuratorDescr = this.findConfiguratorDescription(destProviderId, contributions);
        Assert.assertEquals((String)"Unexpected destination category", (Object)destCategory, (Object)configuratorDescr.destinationCategoryId());
        Assert.assertSame((String)"Unexpected configurator instance", configurator, (Object)configuratorDescr.createConfigurator());
    }

    private ISearchDestinationsConfiguratorDescription findConfiguratorDescription(String destProviderId, List<ISearchDestinationsConfiguratorDescription> contributions) {
        for (ISearchDestinationsConfiguratorDescription descr : contributions) {
            if (!descr.destinationProviderId().equals(destProviderId)) continue;
            return descr;
        }
        Assert.fail((String)("Could not find configurator for destination provider " + destProviderId));
        throw new IllegalStateException();
    }
}

