/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.test.unit.prefpage;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.platform.discovery.destprefs.api.ISearchDestinationConfigurator;
import org.eclipse.platform.discovery.destprefs.api.ISearchDestinationTester;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.CategoryDestinationProviderPair;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.DestinationConfiguratorSelection;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.DestinationConfiguratorsPresenter;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.IDestinationConfiguratorsView;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.SearchDestinationsConfiguratorXPParser;
import org.eclipse.platform.discovery.destprefs.test.unit.SearchConfiguratorsFixture;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class DestinationConfiguratorsPresenterTest {
    private ExtensionRegistryBuilder registryBuilder;
    @Mock
    private IDestinationConfiguratorsView view;
    @Mock
    private Shell viewShell;
    private SearchConfiguratorsFixture fixture;
    private SearchDestinationsConfiguratorXPParser parser;
    private DestinationConfiguratorsPresenter presenter;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.registryBuilder = new ExtensionRegistryBuilder();
        this.fixture = new SearchConfiguratorsFixture();
        this.fixture.setup(this.registryBuilder);
        this.parser = new SearchDestinationsConfiguratorXPParser(this.registryBuilder.getRegistry()){

            protected ISearchProviderConfiguration searchProviderConfiguration() {
                return ((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.searchProviderConfiguration;
            }
        };
        this.presenter = new DestinationConfiguratorsPresenter(this.parser, this.fixture.searchProviderConfiguration);
        Mockito.when((Object)this.view.getShell()).thenReturn((Object)this.viewShell);
        this.presenter.setView(this.view);
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setInput((Collection)Mockito.argThat(this.matchesFixture()));
    }

    private Matcher<Collection<CategoryDestinationProviderPair>> matchesFixture() {
        return new BaseMatcher<Collection<CategoryDestinationProviderPair>>(){
            private Collection<CategoryDestinationProviderPair> actual;

            public boolean matches(Object item) {
                this.actual = (Collection)item;
                return this.actual.containsAll(this.expected()) && this.actual.size() == this.expected().size();
            }

            private Collection<CategoryDestinationProviderPair> expected() {
                ArrayList<CategoryDestinationProviderPair> result = new ArrayList<CategoryDestinationProviderPair>();
                result.add(new CategoryDestinationProviderPair(((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.categoryDesc1, (IDestinationsProviderDescription)((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.searchProviderConfiguration.getDestinationProvidersForCategory(((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.categoryDesc1).get(0)));
                result.add(new CategoryDestinationProviderPair(((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.categoryDesc1, (IDestinationsProviderDescription)((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.searchProviderConfiguration.getDestinationProvidersForCategory(((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.categoryDesc1).get(1)));
                result.add(new CategoryDestinationProviderPair(((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.categoryDesc2, (IDestinationsProviderDescription)((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.searchProviderConfiguration.getDestinationProvidersForCategory(((DestinationConfiguratorsPresenterTest)DestinationConfiguratorsPresenterTest.this).fixture.categoryDesc2).get(0)));
                return result;
            }

            public void describeTo(Description description) {
                description.appendText(this.actual.toString());
            }
        };
    }

    @Test
    public void destinationSelectedTogglesEnablement() {
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(this.fixture.DEST_PROVIDER_CAT1_1, this.fixture.destination1));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setAddEnabled(Mockito.eq((boolean)true));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setEditEnabled(Mockito.eq((boolean)true));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setRemoveEnabled(Mockito.eq((boolean)true));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setTestEnabled(Mockito.eq((boolean)false));
    }

    @Test
    public void add() {
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(this.fixture.DEST_PROVIDER_CAT1_1, null));
        ISearchDestinationConfigurator<ISearchDestination> expectedConfigurator = this.fixture.configurator_1_1;
        IStatus result = Status.OK_STATUS;
        Mockito.when((Object)expectedConfigurator.createDestination((Shell)Mockito.same((Object)this.viewShell))).thenReturn((Object)result);
        this.presenter.addDestination();
        ((ISearchDestinationConfigurator)Mockito.verify(expectedConfigurator)).createDestination((Shell)Mockito.same((Object)this.viewShell));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setStatus((IStatus)Mockito.same((Object)result));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setInput((Collection)Mockito.argThat(this.matchesFixture()));
    }

    @Test
    public void addNotOkDoesNotSetInput() {
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(this.fixture.DEST_PROVIDER_CAT1_1, this.fixture.destination1));
        ISearchDestinationConfigurator<ISearchDestination> expectedConfigurator = this.fixture.configurator_1_1;
        IStatus result = Status.CANCEL_STATUS;
        Mockito.when((Object)expectedConfigurator.createDestination((Shell)Mockito.same((Object)this.viewShell))).thenReturn((Object)result);
        this.presenter.addDestination();
        ((ISearchDestinationConfigurator)Mockito.verify(expectedConfigurator)).createDestination((Shell)Mockito.same((Object)this.viewShell));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setStatus((IStatus)Mockito.same((Object)result));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setInput((Collection)Mockito.argThat(this.matchesFixture()));
    }

    @Test
    public void destinationCategorySelectedTogglesEnablement() {
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(this.fixture.DEST_PROVIDER_CAT1_1, null));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setAddEnabled(Mockito.eq((boolean)true));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setEditEnabled(Mockito.eq((boolean)false));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setRemoveEnabled(Mockito.eq((boolean)false));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setTestEnabled(Mockito.eq((boolean)false));
    }

    @Test
    public void testEnablementWhenHasTester() {
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(this.fixture.DEST_PROVIDER_CAT1_1, null));
        ISearchDestinationTester tester = (ISearchDestinationTester)Mockito.mock(ISearchDestinationTester.class);
        Mockito.when((Object)this.fixture.configurator_1_1.getSearchDestinationTester()).thenReturn((Object)tester);
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(this.fixture.DEST_PROVIDER_CAT1_1, this.fixture.destination1));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setTestEnabled(Mockito.eq((boolean)true));
    }

    @Test
    public void edit() {
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(this.fixture.DEST_PROVIDER_CAT1_1, this.fixture.destination1));
        ISearchDestinationConfigurator<ISearchDestination> expectedConfigurator = this.fixture.configurator_1_1;
        IStatus result = Status.OK_STATUS;
        Mockito.when((Object)expectedConfigurator.editDestination((Shell)Mockito.same((Object)this.viewShell), (ISearchDestination)Mockito.same((Object)this.fixture.destination1))).thenReturn((Object)result);
        this.presenter.editDestination();
        ((ISearchDestinationConfigurator)Mockito.verify(expectedConfigurator)).editDestination((Shell)Mockito.same((Object)this.viewShell), (ISearchDestination)Mockito.same((Object)this.fixture.destination1));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setStatus((IStatus)Mockito.same((Object)result));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setInput((Collection)Mockito.argThat(this.matchesFixture()));
    }

    @Test
    public void remove() {
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(this.fixture.DEST_PROVIDER_CAT1_1, this.fixture.destination1));
        ISearchDestinationConfigurator<ISearchDestination> expectedConfigurator = this.fixture.configurator_1_1;
        IStatus result = Status.OK_STATUS;
        Mockito.when((Object)expectedConfigurator.deleteDestination((Shell)Mockito.same((Object)this.viewShell), (ISearchDestination)Mockito.same((Object)this.fixture.destination1))).thenReturn((Object)result);
        this.presenter.removeDestination();
        ((ISearchDestinationConfigurator)Mockito.verify(expectedConfigurator)).deleteDestination((Shell)Mockito.same((Object)this.viewShell), (ISearchDestination)Mockito.same((Object)this.fixture.destination1));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setStatus((IStatus)Mockito.same((Object)result));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setInput((Collection)Mockito.argThat(this.matchesFixture()));
    }

    @Test
    public void testClearSelection() {
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(null, null));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setAddEnabled(Mockito.eq((boolean)false));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setEditEnabled(Mockito.eq((boolean)false));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setRemoveEnabled(Mockito.eq((boolean)false));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setTestEnabled(Mockito.eq((boolean)false));
    }

    @Test
    public void test() {
        this.presenter.selectionChanged(new DestinationConfiguratorSelection(this.fixture.DEST_PROVIDER_CAT1_1, this.fixture.destination1));
        ISearchDestinationConfigurator<ISearchDestination> expectedConfigurator = this.fixture.configurator_1_1;
        IStatus result = Status.OK_STATUS;
        ISearchDestinationTester destTester = (ISearchDestinationTester)Mockito.mock(ISearchDestinationTester.class);
        Mockito.when((Object)expectedConfigurator.getSearchDestinationTester()).thenReturn((Object)destTester);
        Mockito.when((Object)destTester.test((Shell)Mockito.same((Object)this.viewShell), (ISearchDestination)Mockito.same((Object)this.fixture.destination1))).thenReturn((Object)result);
        this.presenter.testDestination();
        ((ISearchDestinationTester)Mockito.verify((Object)destTester)).test((Shell)Mockito.same((Object)this.viewShell), (ISearchDestination)Mockito.same((Object)this.fixture.destination1));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view)).setStatus((IStatus)Mockito.same((Object)result));
        ((IDestinationConfiguratorsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setInput((Collection)Mockito.argThat(this.matchesFixture()));
    }
}

