/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.imp.ModelImportWizard;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class VCommandEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private TableViewer viewer;
    private EStructuralFeature commandsFeature;
    private List<Action> actions = new ArrayList<Action>();
    private List<Action> actionsImport = new ArrayList<Action>();

    @Inject
    public VCommandEditor() {
        this.commandsFeature = ApplicationPackageImpl.Literals.APPLICATION__COMMANDS;
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.VCommandEditor_AddCommand, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Command")){

            public void run() {
                VCommandEditor.this.handleAdd();
            }
        });
        this.actionsImport.add(new Action("Import Commands", this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Command")){

            public void run() {
                VCommandEditor.this.handleImport();
            }
        });
    }

    @Override
    public Image getImage(Object element, Display display) {
        return null;
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.VCommandEditor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.VCommandEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = this.createForm(parent, this.context, this.getMaster());
        }
        VirtualEntry o = (VirtualEntry)object;
        this.viewer.setInput((Object)o.getList());
        this.getMaster().setValue(o.getOriginalParent());
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        this.viewer = new TableViewer(parent);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)cp);
        GridData gd = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider(this.getEditor(), this.Messages));
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayoutData((Object)new GridData(4, 3, false, false));
        GridLayout gl = new GridLayout();
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonComp.setLayout((Layout)gl);
        Button b = new Button(buttonComp, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_Up);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_up"));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!VCommandEditor.this.viewer.getSelection().isEmpty() && (s = (IStructuredSelection)VCommandEditor.this.viewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    MApplication container = (MApplication)VCommandEditor.this.getMaster().getValue();
                    int idx = container.getCommands().indexOf(obj) - 1;
                    if (idx >= 0 && (cmd = MoveCommand.create((EditingDomain)VCommandEditor.this.getEditingDomain(), (Object)VCommandEditor.this.getMaster().getValue(), (Object)VCommandEditor.this.commandsFeature, (Object)obj, (int)idx)).canExecute()) {
                        VCommandEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                        VCommandEditor.this.viewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        b = new Button(buttonComp, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_Down);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_down"));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!VCommandEditor.this.viewer.getSelection().isEmpty() && (s = (IStructuredSelection)VCommandEditor.this.viewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    MApplication container = (MApplication)VCommandEditor.this.getMaster().getValue();
                    int idx = container.getCommands().indexOf(obj) + 1;
                    if (idx < container.getCommands().size() && (cmd = MoveCommand.create((EditingDomain)VCommandEditor.this.getEditingDomain(), (Object)VCommandEditor.this.getMaster().getValue(), (Object)VCommandEditor.this.commandsFeature, (Object)obj, (int)idx)).canExecute()) {
                        VCommandEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                        VCommandEditor.this.viewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        b = new Button(buttonComp, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_AddEllipsis);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_add"));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VCommandEditor.this.handleAdd();
            }
        });
        b = new Button(buttonComp, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_Remove);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_delete"));
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!VCommandEditor.this.viewer.getSelection().isEmpty()) {
                    List commands = ((IStructuredSelection)VCommandEditor.this.viewer.getSelection()).toList();
                    Command cmd = RemoveCommand.create((EditingDomain)VCommandEditor.this.getEditingDomain(), (Object)VCommandEditor.this.getMaster().getValue(), (Object)VCommandEditor.this.commandsFeature, (Collection)commands);
                    if (cmd.canExecute()) {
                        VCommandEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                    }
                }
            }
        });
        folder.setSelection(0);
        return folder;
    }

    protected void handleAdd() {
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        this.addCommand(command);
    }

    private void addCommand(MCommand command) {
        this.setElementId(command);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)this.commandsFeature, (Object)command);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(command);
        }
    }

    protected void handleImport() {
        ModelImportWizard wizard = new ModelImportWizard(MCommand.class, this, this.resourcePool);
        WizardDialog wizardDialog = new WizardDialog(this.viewer.getControl().getShell(), (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            MCommand[] elements;
            MCommand[] mCommandArray = elements = (MCommand[])wizard.getElements(MCommand.class);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                MCommand mCommand = mCommandArray[n2];
                this.addCommand(mCommand);
                ++n2;
            }
        }
    }

    @Override
    public IObservableList getChildList(Object element) {
        return null;
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }

    @Override
    public List<Action> getActionsImport(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actionsImport);
        return l;
    }
}

