/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.e4.tools.emf.ui.common.IExtensionLookup;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.PatternFilter;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExpressionIdDialog
extends TitleAreaDialog {
    private IExtensionLookup lookup;
    private TableViewer viewer;
    private EditingDomain domain;
    private MCoreExpression expression;
    private boolean liveModel;
    private Messages Messages;

    public ExpressionIdDialog(Shell parentShell, IExtensionLookup lookup, MCoreExpression expression, EditingDomain domain, boolean liveModel, Messages Messages2) {
        super(parentShell);
        this.lookup = lookup;
        this.expression = expression;
        this.domain = domain;
        this.liveModel = liveModel;
        this.Messages = Messages2;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.Messages.ExpressionIdDialog_ShellTitle);
        this.setTitle(this.Messages.ExpressionIdDialog_DialogTitle);
        this.setMessage(this.Messages.ExpressionIdDialog_DialogMessage);
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(this.Messages.ExpressionIdDialog_Id);
        Text idField = new Text(container, 2688);
        idField.setLayoutData((Object)new GridData(768));
        PatternFilter filter = new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }
        };
        l = new Label(container, 0);
        this.viewer = new TableViewer(container);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.viewer.addFilter((ViewerFilter)filter);
        this.viewer.setInput(this.getElements(this.lookup));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ExpressionIdDialog.this.okPressed();
            }
        });
        ControlFactory.attachFiltering(idField, this.viewer, filter);
        return comp;
    }

    protected void okPressed() {
        IConfigurationElement el;
        Command cmd;
        if (!this.viewer.getSelection().isEmpty() && (cmd = SetCommand.create((EditingDomain)this.domain, (Object)this.expression, (Object)UiPackageImpl.Literals.CORE_EXPRESSION__CORE_EXPRESSION_ID, (Object)(el = (IConfigurationElement)((IStructuredSelection)this.viewer.getSelection()).getFirstElement()).getAttribute("id"))).canExecute()) {
            this.domain.getCommandStack().execute(cmd);
            super.okPressed();
        }
    }

    private List<IConfigurationElement> getElements(IExtensionLookup lookup) {
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = lookup.findExtensions("org.eclipse.core.expressions.definitions", this.liveModel);
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                list.add(el);
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    static class LabelProviderImpl
    extends StyledCellLabelProvider
    implements ILabelProvider {
        LabelProviderImpl() {
        }

        public void update(ViewerCell cell) {
            IConfigurationElement el = (IConfigurationElement)cell.getElement();
            StyledString str = new StyledString(el.getAttribute("id"));
            str.append(" - " + el.getContributor().getName(), StyledString.DECORATIONS_STYLER);
            cell.setText(str.getString());
            cell.setStyleRanges(str.getStyleRanges());
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            IConfigurationElement el = (IConfigurationElement)element;
            return String.valueOf(el.getAttribute("id")) + " " + el.getContributor().getName();
        }
    }
}

