/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.script.js;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.tools.emf.ui.common.IScriptingSupport;
import org.eclipse.e4.tools.emf.ui.script.js.ResourceProvider;
import org.eclipse.e4.tools.emf.ui.script.js.text.JavaScriptEditor;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class JavaScriptSupport
implements IScriptingSupport {
    public void openEditor(Shell shell, final Object mainElement, final IEclipseContext context) {
        final IEclipseContext childContext = context.createChild();
        TitleAreaDialog dialog = new TitleAreaDialog(shell){
            private JavaScriptEditor editor;
            private Logger logger;

            protected Control createDialogArea(Composite parent) {
                Composite container = (Composite)super.createDialogArea(parent);
                this.logger = new Logger(this.getShell());
                this.getShell().setText("Execute JavaScript");
                this.setTitle("Execute JavaScript");
                this.setMessage("Enter some JavaScript and execute it");
                this.setTitleImage(((IResourcePool)childContext.get(IResourcePool.class)).getImageUnchecked(ResourceProvider.IMG_WIZBAN_JAVASCRIPT));
                childContext.set(Composite.class, (Object)container);
                this.editor = (JavaScriptEditor)ContextInjectionFactory.make(JavaScriptEditor.class, (IEclipseContext)childContext);
                GridData gd = new GridData(1808);
                gd.minimumHeight = 350;
                gd.minimumWidth = 400;
                this.editor.getControl().setLayoutData((Object)gd);
                return container;
            }

            protected void okPressed() {
                JavaScriptSupport.this.execute(this.logger, mainElement, context, this.editor.getContent());
            }

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                return super.createButton(parent, id, id == 0 ? "Execute" : label, defaultButton);
            }
        };
        dialog.open();
        childContext.dispose();
    }

    private void execute(Logger logger, Object mainElement, IEclipseContext context, String script) {
        Context cx = Context.enter();
        ScriptableObject sc = cx.initStandardObjects();
        ScriptableObject.putProperty((Scriptable)sc, (String)"mainObject", (Object)mainElement);
        ScriptableObject.putProperty((Scriptable)sc, (String)"eclipseContext", (Object)context);
        ScriptableObject.putProperty((Scriptable)sc, (String)"swt", (Object)new SWTSupport(Display.getCurrent()));
        ScriptableObject.putProperty((Scriptable)sc, (String)"service", (Object)new ServiceProvider(context));
        ScriptableObject.putProperty((Scriptable)sc, (String)"di", (Object)new DiProvider(context));
        ScriptableObject.putProperty((Scriptable)sc, (String)"log", (Object)logger);
        try {
            cx.evaluateString((Scriptable)sc, script, "<cmd>", 1, null);
        }
        catch (Exception e) {
            try {
                logger.error(e);
            }
            catch (Exception exception) {}
        }
    }

    public static class DiProvider {
        private IEclipseContext context;
        private PackageAdmin packageAdmin;

        public DiProvider(IEclipseContext context) {
            this.context = context;
        }

        public Object newInstance(String bundlename, String className) throws ClassNotFoundException {
            Bundle bundle = this.getBundle(bundlename);
            if (bundle != null) {
                Class clazz = bundle.loadClass(className);
                return ContextInjectionFactory.make((Class)clazz, (IEclipseContext)this.context);
            }
            return new IllegalArgumentException("Bundle '" + bundlename + "' is not known");
        }

        public Object execute(Object object) {
            return ContextInjectionFactory.invoke((Object)object, Execute.class, (IEclipseContext)this.context);
        }

        public Object invokeByAnnotation(Object object, String bundlename, String className) throws ClassNotFoundException {
            Bundle bundle = this.getBundle(bundlename);
            if (bundle != null) {
                Class clazz = bundle.loadClass(className);
                return ContextInjectionFactory.invoke((Object)object, (Class)clazz, (IEclipseContext)this.context);
            }
            return new IllegalArgumentException("Bundle '" + bundlename + "' is not known");
        }

        private Bundle getBundle(String bundlename) {
            Bundle[] bundles;
            if (this.packageAdmin == null) {
                Bundle bundle = FrameworkUtil.getBundle(this.getClass());
                BundleContext context = bundle.getBundleContext();
                ServiceReference reference = context.getServiceReference(PackageAdmin.class);
                this.packageAdmin = (PackageAdmin)context.getService(reference);
            }
            if ((bundles = this.packageAdmin.getBundles(bundlename, null)) == null) {
                return null;
            }
            int i = 0;
            while (i < bundles.length) {
                if ((bundles[i].getState() & 3) == 0) {
                    return bundles[i];
                }
                ++i;
            }
            return null;
        }
    }

    public static class Logger {
        private Shell parentShell;
        private Shell shell;
        private Text text;
        private static SimpleDateFormat DATEFORMAT = new SimpleDateFormat("hh:mm:ss.SSS");

        public Logger(Shell parentShell) {
            this.parentShell = parentShell;
        }

        public void openLog() {
            if (this.shell == null) {
                this.shell = new Shell(this.parentShell, 1264);
                this.shell.setLayout((Layout)new GridLayout());
                this.text = new Text((Composite)this.shell, 2818);
                this.text.setLayoutData((Object)new GridData(1808));
                this.text.setFont(JFaceResources.getTextFont());
                this.text.setEditable(false);
                this.shell.setVisible(true);
                this.shell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        Logger.this.shell = null;
                        Logger.this.text = null;
                    }
                });
            }
        }

        public void error(Object data) throws Exception {
            this._log(1, data);
        }

        public void debug(Object data) throws Exception {
            this._log(0, data);
        }

        private void _log(int type, Object data) throws Exception {
            if (this.shell == null) {
                this.openLog();
            }
            this.shell.setVisible(true);
            if (data instanceof Throwable) {
                StringWriter w = new StringWriter();
                PrintWriter pw = new PrintWriter(w);
                ((Throwable)data).printStackTrace(pw);
                this.text.append(String.valueOf(DATEFORMAT.format(new Date())) + " - " + w + "\n");
                pw.close();
                w.close();
            } else {
                this.text.append(String.valueOf(DATEFORMAT.format(new Date())) + " - " + data + "\n");
            }
        }

        public void clearLog() {
            if (this.text != null) {
                this.text.setText("");
            }
        }

        public void closeLog() {
            this.shell.dispose();
            this.shell = null;
            this.text = null;
        }
    }

    public static class SWTSupport {
        private Display d;
        public static SWT SWT = new SWT();

        public SWTSupport(Display d) {
            this.d = d;
        }

        public Color newColor(String color) {
            if (color.startsWith("#")) {
                if (color.length() == 7) {
                    return new Color((Device)this.d, new RGB(Integer.parseInt(color.substring(1, 3), 16), Integer.parseInt(color.substring(3, 5), 16), Integer.parseInt(color.substring(5, 7), 16)));
                }
                return new Color((Device)this.d, new RGB(Integer.parseInt(String.valueOf(color.charAt(1)) + color.charAt(1), 16), Integer.parseInt(String.valueOf(color.charAt(2)) + color.charAt(2), 16), Integer.parseInt(String.valueOf(color.charAt(3)) + color.charAt(3), 16)));
            }
            return null;
        }

        public Text newText(Composite parent, int style) {
            return new Text(parent, style);
        }

        public Widget newLabel(Composite parent, int style) {
            return new Label(parent, style);
        }

        public GridData newGridData() {
            return new GridData();
        }

        public Combo newCombo(Composite parent, int style) {
            return new Combo(parent, style);
        }
    }

    public static class ServiceProvider {
        private IEclipseContext context;

        public ServiceProvider(IEclipseContext context) {
            this.context = context;
        }

        public Object getStyleEngine() {
            return this.context.get(IStylingEngine.class);
        }

        public Object getPartService() {
            return this.context.get("org.eclipse.e4.ui.workbench.modeling.EPartService");
        }

        public Object getModelService() {
            return this.context.get("org.eclipse.e4.ui.workbench.modeling.EModelService");
        }
    }
}

