/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;

public class PDEClassContributionProvider
implements IClassContributionProvider {
    private SearchEngine searchEngine = new SearchEngine();

    public void findContribution(IClassContributionProvider.Filter filter, final IClassContributionProvider.ContributionResultHandler handler) {
        IJavaSearchScope scope = filter.project != null ? PDEJavaHelper.getSearchScope((IProject)filter.project) : SearchEngine.createWorkspaceScope();
        char[] packageName = null;
        char[] typeName = null;
        String currentContent = filter.namePattern;
        int index = currentContent.lastIndexOf(46);
        if (index == -1) {
            typeName = currentContent.toCharArray();
            if (currentContent.startsWith("*")) {
                if (!currentContent.endsWith("*")) {
                    currentContent = String.valueOf(currentContent) + "*";
                }
                typeName = currentContent.toCharArray();
                packageName = "*".toCharArray();
            }
        } else if (index + 1 == currentContent.length()) {
            typeName = "".toCharArray();
            packageName = currentContent.substring(0, index).toCharArray();
        } else {
            typeName = currentContent.substring(index + 1).toCharArray();
            packageName = currentContent.substring(0, index).toCharArray();
        }
        TypeNameRequestor req = new TypeNameRequestor(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                IProject project;
                IFile f;
                String cName = new String(simpleTypeName);
                String pName = new String(packageName);
                String content = pName.length() == 0 ? cName : String.valueOf(pName) + "." + cName;
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (resource == null || (f = (project = resource.getProject()).getFile("/META-INF/MANIFEST.MF")) == null || !f.exists()) return;
                BufferedReader r = null;
                try {
                    try {
                        String line;
                        InputStream s = f.getContents();
                        r = new BufferedReader(new InputStreamReader(s));
                        while ((line = r.readLine()) != null) {
                            if (!line.startsWith("Bundle-SymbolicName:")) continue;
                            int start = line.indexOf(58);
                            int end = line.indexOf(59);
                            if (end == -1) {
                                end = line.length();
                            }
                            IClassContributionProvider.ContributionData data = new IClassContributionProvider.ContributionData(line.substring(start + 1, end).trim(), content, "Java", null);
                            handler.result(data);
                            return;
                        }
                        return;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        if (r == null) return;
                        try {
                            r.close();
                            return;
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        return;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (r == null) return;
                        try {
                            r.close();
                            return;
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                        return;
                    }
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        try {
            this.searchEngine.searchAllTypeNames(packageName, 2, typeName, 130, 5, scope, req, 3, null);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }
}

