/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.di.internal.extensions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.e4.core.di.internal.extensions.PreferencesObjectSupplier;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class DIEActivator
implements BundleActivator {
    private static DIEActivator defaultInstance;
    private BundleContext bundleContext;
    private ServiceTracker preferencesTracker;
    private ServiceTracker eventAdminTracker;
    private Set<PreferencesObjectSupplier> preferenceSuppliers = new HashSet<PreferencesObjectSupplier>();

    public DIEActivator() {
        defaultInstance = this;
    }

    public static DIEActivator getDefault() {
        return defaultInstance;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        for (PreferencesObjectSupplier supplier : this.preferenceSuppliers) {
            supplier.removeAllListeners();
        }
        this.preferenceSuppliers.clear();
        if (this.preferencesTracker != null) {
            this.preferencesTracker.close();
            this.preferencesTracker = null;
        }
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        this.bundleContext = null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public IPreferencesService getPreferencesService() {
        if (this.preferencesTracker == null) {
            if (this.bundleContext == null) {
                return null;
            }
            this.preferencesTracker = new ServiceTracker(this.bundleContext, IPreferencesService.class.getName(), null);
            this.preferencesTracker.open();
        }
        return (IPreferencesService)this.preferencesTracker.getService();
    }

    public EventAdmin getEventAdmin() {
        if (this.eventAdminTracker == null) {
            if (this.bundleContext == null) {
                return null;
            }
            this.eventAdminTracker = new ServiceTracker(this.bundleContext, EventAdmin.class.getName(), null);
            this.eventAdminTracker.open();
        }
        return (EventAdmin)this.eventAdminTracker.getService();
    }

    public void registerPreferencesSupplier(PreferencesObjectSupplier supplier) {
        this.preferenceSuppliers.add(supplier);
    }
}

