/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.cacheservice;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.internal.resources.semantic.cacheservice.ICachedContentHandle;
import org.eclipse.core.internal.resources.semantic.cacheservice.MemoryCache;
import org.eclipse.core.runtime.CoreException;

class CachedMemoryHandle
implements ICachedContentHandle {
    private final MemoryCache myCache;
    private final String myPath;
    private byte[] myContent = new byte[0];
    boolean exists = false;

    public CachedMemoryHandle(String path, MemoryCache cache) {
        this.myPath = path;
        this.myCache = cache;
    }

    public boolean exists() {
        return this.exists;
    }

    public void delete() {
        this.exists = false;
        this.myCache.removeStore(this.myPath);
    }

    public InputStream openInputStream() throws CoreException {
        return new ByteArrayInputStream(this.myContent);
    }

    public void setContents(byte[] contents, boolean append) {
        this.exists = true;
        if (append && this.myContent.length > 0) {
            byte[] oldContent = this.myContent;
            this.myContent = new byte[oldContent.length + contents.length];
            System.arraycopy(oldContent, 0, this.myContent, 0, oldContent.length);
            System.arraycopy(contents, 0, this.myContent, oldContent.length, contents.length);
        } else {
            this.myContent = contents;
        }
    }
}

