/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.List;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoListPropertyDecorator<S, E>
extends ListProperty<S, E>
implements IBeanListProperty<S, E> {
    private final IListProperty<S, E> delegate;
    private final PropertyDescriptor propertyDescriptor;

    public PojoListPropertyDecorator(IListProperty<S, E> delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    public Object getElementType() {
        return this.delegate.getElementType();
    }

    public Class<E> getElementClass() {
        return this.delegate.getElementClass();
    }

    protected List<E> doGetList(S source) {
        return this.delegate.getList(source);
    }

    protected void doSetList(S source, List<E> list) {
        this.delegate.setList(source, list);
    }

    protected void doUpdateList(S source, ListDiff<E> diff) {
        this.delegate.updateList(source, diff);
    }

    @Override
    public <T> IBeanListProperty<S, T> values(String propertyName) {
        return this.values(propertyName, (Class<T>)null);
    }

    @Override
    public <T> IBeanListProperty<S, T> values(String propertyName, Class<T> valueType) {
        Class beanClass = this.delegate.getElementClass();
        return this.values(PojoProperties.value(beanClass, propertyName, valueType));
    }

    @Override
    public <T> IBeanListProperty<S, T> values(IBeanValueProperty<E, T> property) {
        return new PojoListPropertyDecorator<S, E>(super.values(property), property.getPropertyDescriptor());
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public IObservableList<E> observe(S source) {
        return new BeanObservableListDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableList<E> observe(Realm realm, S source) {
        return new BeanObservableListDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public <M extends S> IObservableList<E> observeDetail(IObservableValue<M> master) {
        return new BeanObservableListDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

