/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view;

import java.util.List;
import java.util.Set;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleController;
import org.eclipse.platform.discovery.runtime.api.IDestinationChangeHandler;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.DestinationCategoryNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.selector.ComboSelector;
import org.eclipse.platform.discovery.ui.internal.view.ISearchProviderSelector;
import org.eclipse.platform.discovery.ui.internal.view.impl.IControlValueSelector;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchConsoleDestinationsSelector;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchForSelectionChangeListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchProviderSelector
implements ISearchProviderSelector {
    private IControlValueSelector<IObjectTypeDescription, Combo> searchForComboViewer;
    private SearchConsoleDestinationsSelector destinationsSelector;
    private ISearchConsoleController controller;
    private final ISearchProviderSelector.IConsoleContext consoleContext;
    private final Composite selectorComposite;

    @Override
    public void setController(ISearchConsoleController controller) {
        this.controller = controller;
    }

    public SearchProviderSelector(Composite parent, FormToolkit toolkit, ISearchProviderSelector.IConsoleContext consoleContext) {
        this.consoleContext = consoleContext;
        this.selectorComposite = new Composite(parent, 0);
        this.selectorComposite.setLayout((Layout)new FormLayout());
        this.createSearchForViewer(toolkit);
        this.createDestinationsSelector(toolkit);
    }

    private void createSearchForViewer(FormToolkit toolkit) {
        this.searchForComboViewer = new ComboSelector<IObjectTypeDescription>(this.selectorComposite, toolkit, this.getObjectTypes(), DiscoveryUIMessages.SEARCH_FOR_LIST_VIEWER_LABEL, this.consoleContext.secondColumnLeftOffset(), null);
        this.searchForComboViewer.registerSelectionChangedListener(new SearchForSelectionChangeListener(){

            @Override
            protected void objectTypeSelected(IObjectTypeDescription objectType) {
                SearchProviderSelector.this.controller.objectTypeSelected(objectType);
                SearchProviderSelector.this.consoleContext.notifyComplete(SearchProviderSelector.this.isSearchProviderAvailable(objectType, SearchProviderSelector.this.destinationsSelector.getSelectedItem()));
            }
        });
    }

    private void createDestinationsSelector(FormToolkit toolkit) {
        this.destinationsSelector = new SearchConsoleDestinationsSelector(this.selectorComposite, toolkit, this.consoleContext.secondColumnLeftOffset(), this.searchForComboViewer.getControl(), this.consoleContext.searchProviderConfiguration()){

            public void handleSelectionChange(ISearchDestination newSelection) {
                IObjectTypeDescription selectedObjectType = (IObjectTypeDescription)SearchProviderSelector.this.searchForComboViewer.getSelectedItem();
                if (selectedObjectType == null) {
                    return;
                }
                SearchProviderSelector.this.consoleContext.notifyComplete(SearchProviderSelector.this.isSearchProviderAvailable(selectedObjectType, newSelection));
            }
        };
        this.destinationsSelector.registerDestinationsChangeHandler(new IDestinationChangeHandler(){

            public void handleDestinationsChange() {
                SearchProviderSelector.this.controller.searchDestinationsChanged();
            }
        });
        this.destinationsSelector.setEnabled(false);
    }

    private List<IObjectTypeDescription> getObjectTypes() {
        return this.consoleContext.searchProviderConfiguration().getObjectTypes();
    }

    @Override
    public void setDestinations(List<IDestinationCategoryDescription> categories) {
        this.destinationsSelector.setEnabled(categories.size() > 0);
        this.destinationsSelector.setInput(categories);
    }

    public void setObjectTypes(Set<IObjectTypeDescription> objectTypes) {
        this.searchForComboViewer.setInput(objectTypes);
    }

    public Control getDestinationsControl() {
        return this.destinationsSelector.getControl();
    }

    @Override
    public IObjectTypeDescription getSelectedObjectType() {
        return (IObjectTypeDescription)this.searchForComboViewer.getSelectedItem();
    }

    @Override
    public ISearchDestination getSelectedDestination() {
        return this.destinationsSelector.getSelectedItem();
    }

    @Override
    public void updateDestinationsUI() {
        this.destinationsSelector.update();
    }

    @Override
    public ISearchProviderDescription getSelectedSearchProvider() {
        return this.getSelectedSearchProvider((IObjectTypeDescription)this.searchForComboViewer.getSelectedItem(), this.destinationsSelector.getSelectedItem());
    }

    private ISearchProviderDescription getSelectedSearchProvider(IObjectTypeDescription selectedObjectType, ISearchDestination selectedDestination) {
        if (selectedObjectType == null) {
            return null;
        }
        try {
            return this.consoleContext.searchProviderConfiguration().getActiveSearchProvider(selectedObjectType, this.getSelectedCategory(this.destinationsSelector.getSelectedItem()));
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            return null;
        }
    }

    @Override
    public void setObjectTypes(List<IObjectTypeDescription> objectTypes) {
        this.searchForComboViewer.setInput(objectTypes);
    }

    private boolean isSearchProviderAvailable(IObjectTypeDescription selectedObjectType, ISearchDestination selectedDestination) {
        return this.getSelectedSearchProvider(selectedObjectType, selectedDestination) != null;
    }

    private IDestinationCategoryDescription getSelectedCategory(ISearchDestination selectedDestination) {
        if (selectedDestination == null) {
            return null;
        }
        try {
            return (IDestinationCategoryDescription)this.consoleContext.searchProviderConfiguration().getDestinationCategoriesForDestination(selectedDestination).iterator().next();
        }
        catch (DestinationCategoryNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Composite getControl() {
        return this.selectorComposite;
    }

    @Override
    public IDestinationCategoryDescription getActiveDestinationCategory() {
        return this.destinationsSelector.getActiveDestinationCategory();
    }
}

