/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.compatibility.tests.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.util.internal.StatusUtils;
import org.eclipse.search.ui.ISearchPage;
import org.mockito.Mockito;

public class CompatibilityRegistryBuilder
extends ExtensionRegistryBuilder {
    private IExtensionPoint searchPagesExtensionPoint;
    private List<IConfigurationElement> searchPageElements = new ArrayList<IConfigurationElement>();

    public CompatibilityRegistryBuilder() {
        this.searchPagesExtensionPoint = this.setupExtensionPoint("org.eclipse.search.searchPages");
    }

    protected void setupExtensionPointConfigElements() {
        super.setupExtensionPointConfigElements();
        Mockito.when((Object)this.searchPagesExtensionPoint.getConfigurationElements()).thenReturn((Object)this.searchPageElements.toArray(new IConfigurationElement[0]));
    }

    protected void clearState() {
        this.searchPageElements.clear();
        super.clearState();
    }

    public void addSearchPage(String id, String displayname, ISearchPage page) {
        IConfigurationElement pageElement = this.searchPageElement(id, displayname);
        this.setExecutableExtension(pageElement, page, "class");
        this.searchPageElements.add(pageElement);
    }

    private IConfigurationElement searchPageElement(String id, String displayname) {
        IConfigurationElement pageElement = this.createConfigurationElement("page");
        this.setAttribute(pageElement, "id", id);
        this.setAttribute(pageElement, "label", displayname);
        return pageElement;
    }

    public void addExceptionThrowingSearchPage(String id, String displayname) {
        this.addExceptionThrowingSearchPage(id, displayname, new CoreException(StatusUtils.statusError((String)"test")));
    }

    public void addExceptionThrowingSearchPage(String id, String displayname, CoreException toThrow) {
        IConfigurationElement pageElement = this.searchPageElement(id, displayname);
        this.setupCreateExecutableExtensionToThrowException(pageElement, "class", toThrow);
        this.searchPageElements.add(pageElement);
    }
}

