/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.compatibility.internal.readers.impl;

import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.compatibility.internal.readers.ISearchPageDescription;
import org.eclipse.platform.discovery.compatibility.internal.readers.impl.SearchPageParser;
import org.eclipse.platform.discovery.compatibility.tests.util.CompatibilityParserTest;
import org.eclipse.platform.discovery.compatibility.tests.util.CompatibilityRegistryBuilder;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.search.ui.ISearchPage;
import org.junit.Assert;
import org.mockito.Mockito;

public class SearchPageParserTest
extends CompatibilityParserTest<ISearchPageDescription> {
    private ISearchPage page1;
    private ISearchPage page2;

    protected AbstractExtensionPointParser<ISearchPageDescription> createParser(IExtensionRegistry registry) {
        return new SearchPageParser(registry);
    }

    protected void setupRegistry(CompatibilityRegistryBuilder registryBuilder) {
        this.page1 = (ISearchPage)Mockito.mock(ISearchPage.class);
        this.page2 = null;
        registryBuilder.addSearchPage("id1", "Pesho", this.page1);
        registryBuilder.addSearchPage("id2", "Gosho", this.page2);
    }

    protected void verifyContributions(List<ISearchPageDescription> contributions) {
        Assert.assertEquals((String)"Two contributors expected", (long)2L, (long)contributions.size());
        this.verifySearchPage(contributions.get(0), "id1", "Pesho", this.page1);
        this.verifySearchPage(contributions.get(1), "id2", "Gosho", this.page2);
    }

    private void verifySearchPage(ISearchPageDescription page, String expectedId, String expectedDisplayname, ISearchPage expectedSearchPage) {
        Assert.assertEquals((String)"unexpected id", (Object)expectedId, (Object)page.getId());
        Assert.assertEquals((String)"unexpected display name", (Object)expectedDisplayname, (Object)page.getDisplayName());
        Assert.assertSame((String)"unexpected search page", (Object)expectedSearchPage, (Object)page.getSearchPage());
    }
}

