/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class Snippet020TreeViewerWithSetFactory {
    private Button pasteButton;
    private Button copyButton;
    private Shell shell;
    private Button addChildBeanButton;
    private Button removeBeanButton;
    private TreeViewer beanViewer;
    private Tree tree;
    private Text beanText;
    private DataBindingContext m_bindingContext;
    private Bean input = Snippet020TreeViewerWithSetFactory.createBean("input");
    private IObservableValue clipboard;
    static int counter = 0;

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                try {
                    Snippet020TreeViewerWithSetFactory window = new Snippet020TreeViewerWithSetFactory();
                    window.open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void open() {
        Display display = Display.getDefault();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContents() {
        this.shell = new Shell();
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        this.shell.setLayout((Layout)gridLayout_1);
        this.shell.setSize(535, 397);
        this.shell.setText("SWT Application");
        Composite group = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 0;
        rowLayout.pack = false;
        group.setLayout((Layout)rowLayout);
        group.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Button addRootButton = new Button(group, 0);
        addRootButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set set = Snippet020TreeViewerWithSetFactory.this.input.getSet();
                Bean root = Snippet020TreeViewerWithSetFactory.createBean("root");
                set.add(root);
                Snippet020TreeViewerWithSetFactory.this.input.setSet(set);
                Snippet020TreeViewerWithSetFactory.this.beanViewer.setSelection((ISelection)new StructuredSelection((Object)root));
                Snippet020TreeViewerWithSetFactory.this.beanText.selectAll();
                Snippet020TreeViewerWithSetFactory.this.beanText.setFocus();
            }
        });
        addRootButton.setText("Add Root");
        this.addChildBeanButton = new Button(group, 0);
        this.addChildBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Bean parent = Snippet020TreeViewerWithSetFactory.this.getSelectedBean();
                HashSet<Bean> set = new HashSet<Bean>(parent.getSet());
                Bean child = Snippet020TreeViewerWithSetFactory.createBean("child" + counter++);
                set.add(child);
                parent.setSet(set);
            }
        });
        this.addChildBeanButton.setText("Add Child");
        this.removeBeanButton = new Button(group, 0);
        this.removeBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem selectedItem = Snippet020TreeViewerWithSetFactory.this.beanViewer.getTree().getSelection()[0];
                Bean bean = (Bean)selectedItem.getData();
                TreeItem parentItem = selectedItem.getParentItem();
                Bean parent = parentItem == null ? Snippet020TreeViewerWithSetFactory.this.input : (Bean)parentItem.getData();
                HashSet set = new HashSet(parent.getSet());
                set.remove(bean);
                parent.setSet(set);
            }
        });
        this.removeBeanButton.setText("Remove");
        this.copyButton = new Button(group, 0);
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Snippet020TreeViewerWithSetFactory.this.clipboard.setValue((Object)Snippet020TreeViewerWithSetFactory.this.getSelectedBean());
            }
        });
        this.copyButton.setText("Copy");
        this.pasteButton = new Button(group, 0);
        this.pasteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Bean copy = (Bean)Snippet020TreeViewerWithSetFactory.this.clipboard.getValue();
                if (copy == null) {
                    return;
                }
                Bean parent = Snippet020TreeViewerWithSetFactory.this.getSelectedBean();
                if (parent == null) {
                    parent = Snippet020TreeViewerWithSetFactory.this.input;
                }
                HashSet<Bean> set = new HashSet<Bean>(parent.getSet());
                set.add(copy);
                parent.setSet(set);
                Snippet020TreeViewerWithSetFactory.this.beanViewer.setSelection((ISelection)new StructuredSelection((Object)copy));
                Snippet020TreeViewerWithSetFactory.this.beanText.selectAll();
                Snippet020TreeViewerWithSetFactory.this.beanText.setFocus();
            }
        });
        this.pasteButton.setText("Paste");
        Button refreshButton = new Button(group, 0);
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Snippet020TreeViewerWithSetFactory.this.beanViewer.refresh();
            }
        });
        refreshButton.setText("Refresh");
        this.beanViewer = new TreeViewer((Composite)this.shell, 67584);
        this.beanViewer.setUseHashlookup(true);
        this.beanViewer.setComparator(new ViewerComparator());
        this.tree = this.beanViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label itemNameLabel = new Label((Composite)this.shell, 0);
        itemNameLabel.setText("Item Name");
        this.beanText = new Text((Composite)this.shell, 2048);
        GridData gd_beanValue = new GridData(4, 0x1000000, true, false);
        this.beanText.setLayoutData((Object)gd_beanValue);
        this.m_bindingContext = this.initDataBindings();
        this.initExtraBindings(this.m_bindingContext);
    }

    private static Bean createBean(String name) {
        return new Bean(name);
    }

    protected DataBindingContext initDataBindings() {
        IViewerObservableValue treeViewerSelectionObserveSelection = ViewersObservables.observeSingleSelection((Viewer)this.beanViewer);
        ISWTObservableValue textTextObserveWidget = SWTObservables.observeText((Control)this.beanText, (int)24);
        IObservableValue treeViewerValueObserveDetailValue = BeansObservables.observeDetailValue((IObservableValue)treeViewerSelectionObserveSelection, (String)"text", String.class);
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)textTextObserveWidget, treeViewerValueObserveDetailValue);
        return bindingContext;
    }

    private Bean getSelectedBean() {
        IStructuredSelection selection = (IStructuredSelection)this.beanViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (Bean)selection.getFirstElement();
    }

    private void initExtraBindings(DataBindingContext dbc) {
        IViewerObservableValue beanViewerSelection = ViewersObservables.observeSingleSelection((Viewer)this.beanViewer);
        ComputedValue beanSelected = new ComputedValue(Boolean.TYPE, (IObservableValue)beanViewerSelection){
            private final /* synthetic */ IObservableValue val$beanViewerSelection;
            {
                this.val$beanViewerSelection = iObservableValue;
                super($anonymous0);
            }

            protected Object calculate() {
                return this.val$beanViewerSelection.getValue() != null;
            }
        };
        dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.addChildBeanButton), (IObservableValue)beanSelected);
        dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.removeBeanButton), (IObservableValue)beanSelected);
        this.clipboard = new WritableValue();
        dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.copyButton), (IObservableValue)beanSelected);
        dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.pasteButton), (IObservableValue)new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                return Snippet020TreeViewerWithSetFactory.this.clipboard.getValue() != null;
            }
        });
        ViewerSupport.bind((AbstractTreeViewer)this.beanViewer, (Object)this.input, (ISetProperty)BeanProperties.set((String)"set", Bean.class), (IValueProperty)BeanProperties.value(Bean.class, (String)"text"));
    }

    static class Bean {
        PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        private String text;
        private Set set;

        public Bean(String text) {
            this.text = text;
            this.set = new HashSet();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String value) {
            this.text = value;
            this.changeSupport.firePropertyChange("text", this.text, this.text);
        }

        public Set getSet() {
            if (this.set == null) {
                return null;
            }
            return new HashSet(this.set);
        }

        public void setSet(Set set) {
            if (set != null) {
                set = new HashSet(set);
            }
            this.set = set;
            this.changeSupport.firePropertyChange("set", this.set, this.set);
        }

        public boolean hasListeners(String propertyName) {
            return this.changeSupport.hasListeners(propertyName);
        }
    }
}

