/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.imp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.tools.emf.ui.common.IExtensionLookup;
import org.eclipse.e4.tools.emf.ui.internal.imp.RegistryStruct;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.ui.advanced.MAdvancedFactory;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryUtil {
    public static MApplicationElement[] getModelElements(Class<? extends MApplicationElement> t, MApplication application, IConfigurationElement ... elements) {
        Assert.isNotNull(t);
        Assert.isNotNull((Object)elements);
        Assert.isTrue((elements.length > 0 ? 1 : 0) != 0);
        if (t.equals(MCommand.class)) {
            return RegistryUtil.getCommands(elements, application);
        }
        if (t.equals(MCategory.class)) {
            return RegistryUtil.getCategories(elements);
        }
        if (t.equals(MPerspective.class)) {
            return RegistryUtil.getPerspectives(elements);
        }
        if (t.equals(MPart.class)) {
            return RegistryUtil.getParts(elements);
        }
        if (t.equals(MHandler.class)) {
            return RegistryUtil.getHandlers(elements, application);
        }
        return new MApplicationElement[0];
    }

    private static MCommand[] getCommands(IConfigurationElement[] elements, MApplication application) {
        ArrayList<MCommand> result = new ArrayList<MCommand>();
        MCommandsFactory commandsFactory = MCommandsFactory.INSTANCE;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MCommand command = commandsFactory.createCommand();
            command.setCommandName(element.getAttribute("name"));
            command.setDescription(element.getAttribute("description"));
            command.setElementId(element.getAttribute("id"));
            String catId = element.getAttribute("categoryId");
            if (catId != null && catId.trim().length() > 0) {
                List categories = application.getCategories();
                for (MCategory category : categories) {
                    if (!category.getElementId().equals(catId)) continue;
                    command.setCategory(category);
                    break;
                }
            }
            result.add(command);
            ++n2;
        }
        return result.toArray(new MCommand[0]);
    }

    private static MPerspective[] getPerspectives(IConfigurationElement[] elements) {
        ArrayList<MPerspective> result = new ArrayList<MPerspective>();
        MAdvancedFactory factory = MAdvancedFactory.INSTANCE;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MPerspective perspective = factory.createPerspective();
            perspective.setLabel(element.getAttribute("name"));
            perspective.setIconURI(RegistryUtil.getIconURI(element, "icon"));
            perspective.setElementId(element.getAttribute("id"));
            perspective.setToBeRendered(true);
            perspective.setVisible(true);
            result.add(perspective);
            ++n2;
        }
        return result.toArray(new MPerspective[0]);
    }

    private static MCategory[] getCategories(IConfigurationElement[] elements) {
        ArrayList<MCategory> result = new ArrayList<MCategory>();
        MCommandsFactory commandsFactory = MCommandsFactory.INSTANCE;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MCategory category = commandsFactory.createCategory();
            category.setDescription(element.getAttribute("description"));
            category.setElementId(element.getAttribute("id"));
            category.setName(element.getAttribute("name"));
            result.add(category);
            ++n2;
        }
        return result.toArray(new MCategory[0]);
    }

    private static MPart[] getParts(IConfigurationElement[] elements) {
        ArrayList<MPart> result = new ArrayList<MPart>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MPart part = (MPart)EcoreUtil.create((EClass)BasicPackageImpl.Literals.PART);
            part.setElementId(element.getAttribute("id"));
            part.setLabel(element.getAttribute("name"));
            part.setIconURI(RegistryUtil.getIconURI(element, "icon"));
            part.setContributionURI(RegistryUtil.getContributionURI(element, "class"));
            part.setToBeRendered(true);
            part.setVisible(true);
            part.setToolbar(MMenuFactory.INSTANCE.createToolBar());
            part.setCloseable(true);
            result.add(part);
            ++n2;
        }
        return result.toArray(new MPart[0]);
    }

    private static MHandler[] getHandlers(IConfigurationElement[] elements, MApplication application) {
        ArrayList<MHandler> result = new ArrayList<MHandler>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MHandler hand = MCommandsFactory.INSTANCE.createHandler();
            hand.setElementId(element.getAttribute("id"));
            hand.setContributionURI(RegistryUtil.getContributionURI(element, "class"));
            String cmdId = element.getAttribute("commandId");
            if (cmdId != null && cmdId.trim().length() > 0) {
                List categories = application.getCommands();
                for (MCommand command : categories) {
                    if (!command.getElementId().equals(cmdId)) continue;
                    hand.setCommand(command);
                    break;
                }
            }
            result.add(hand);
            ++n2;
        }
        return result.toArray(new MHandler[0]);
    }

    private static String getIconURI(IConfigurationElement element, String attribute) {
        return "platform:/plugin/" + element.getContributor().getName() + "/" + element.getAttribute(attribute);
    }

    private static String getContributionURI(IConfigurationElement element, String attribute) {
        return "bundleclass://" + element.getContributor().getName() + "/" + element.getAttribute(attribute);
    }

    public static String[] getProvidingBundles(IExtensionRegistry registry, String extensionPoint, boolean isLive) {
        IExtension[] extensions;
        IExtensionLookup service = RegistryUtil.getService(IExtensionLookup.class, null);
        if (service == null) {
            return new String[]{"No " + IExtensionLookup.class.getName() + " service found."};
        }
        ArrayList<String> result = new ArrayList<String>();
        IExtension[] iExtensionArray = extensions = service.findExtensions(extensionPoint, isLive);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (!result.contains(element.getContributor().getName())) {
                    result.add(element.getContributor().getName());
                }
                ++n4;
            }
            ++n2;
        }
        Object[] resultArray = result.toArray(new String[0]);
        Arrays.sort(resultArray);
        return resultArray;
    }

    public static IConfigurationElement[] getExtensions(IExtensionRegistry registry, RegistryStruct struct, boolean isLive) {
        IExtension[] extensions;
        IExtensionLookup service = RegistryUtil.getService(IExtensionLookup.class, null);
        if (struct == null || service == null) {
            return new IConfigurationElement[0];
        }
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions = service.findExtensions(struct.getExtensionPoint(), isLive);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getContributor().getName().equals(struct.getBundle()) && element.getName().equals(struct.getExtensionPointName())) {
                    result.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IConfigurationElement[0]);
    }

    public static RegistryStruct getStruct(Class<? extends MApplicationElement> applicationElement) {
        if (applicationElement == MCommand.class) {
            return new RegistryStruct("", "org.eclipse.ui.commands", "command", "name");
        }
        if (applicationElement == MCategory.class) {
            return new RegistryStruct("", "org.eclipse.ui.commands", "category", "name");
        }
        if (applicationElement == MPerspective.class) {
            return new RegistryStruct("", "org.eclipse.ui.perspectives", "perspective", "name");
        }
        if (applicationElement == MPart.class) {
            return new RegistryStruct("", "org.eclipse.ui.views", "view", "name");
        }
        if (applicationElement == MHandler.class) {
            return new RegistryStruct("", "org.eclipse.ui.handlers", "handler", "commandId");
        }
        if (applicationElement == MPart.class) {
            return new RegistryStruct("", "org.eclipse.ui.views", "view", "name");
        }
        return null;
    }

    private static <T> T getService(Class<T> clazz, String filter) {
        try {
            BundleContext context = FrameworkUtil.getBundle(RegistryUtil.class).getBundleContext();
            Collection references = context.getServiceReferences(clazz, filter);
            Iterator iterator = references.iterator();
            if (iterator.hasNext()) {
                ServiceReference reference = (ServiceReference)iterator.next();
                return (T)context.getService(reference);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return null;
    }
}

