/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x.emf;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.osgi.framework.Bundle;

public class EditUIUtil {
    static final Class<?> FILE_CLASS;
    static final Class<?> FILE_REVISION_CLASS;
    static final Method FILE_REVISION_GET_URI_METHOD;
    static final Class<?> URI_EDITOR_INPUT_CLASS;

    static {
        Class<IFile> fileClass = null;
        try {
            fileClass = IFile.class;
        }
        catch (Exception exception) {}
        FILE_CLASS = fileClass;
        Class fileRevisionClass = null;
        Method fileRevisionGetURIMethod = null;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.team.core");
        if (bundle != null && (bundle.getState() & 0x2C) != 0) {
            try {
                fileRevisionClass = bundle.loadClass("org.eclipse.team.core.history.IFileRevision");
                fileRevisionGetURIMethod = fileRevisionClass.getMethod("getURI", new Class[0]);
            }
            catch (Exception exception) {}
        }
        FILE_REVISION_CLASS = fileRevisionClass;
        FILE_REVISION_GET_URI_METHOD = fileRevisionGetURIMethod;
        Class<IURIEditorInput> uriEditorInputClass = null;
        try {
            uriEditorInputClass = IURIEditorInput.class;
        }
        catch (Exception exception) {}
        URI_EDITOR_INPUT_CLASS = uriEditorInputClass;
    }

    public static URI getURI(IEditorInput editorInput) {
        Object fileRevision;
        IFile file;
        if (FILE_CLASS != null && (file = (IFile)editorInput.getAdapter(FILE_CLASS)) != null) {
            return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        }
        if (FILE_REVISION_CLASS != null && (fileRevision = editorInput.getAdapter(FILE_REVISION_CLASS)) != null) {
            try {
                return URI.createURI((String)((java.net.URI)FILE_REVISION_GET_URI_METHOD.invoke(fileRevision, new Object[0])).toString());
            }
            catch (Exception exception) {}
        }
        if (URI_EDITOR_INPUT_CLASS != null && editorInput instanceof IURIEditorInput) {
            return URI.createURI((String)((IURIEditorInput)editorInput).getURI().toString()).trimFragment();
        }
        return null;
    }
}

