/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.spi;

import org.eclipse.core.internal.resources.semantic.util.ITraceLocation;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SfsSpiTraceLocation implements ITraceLocation
{
    CORE("/debug/core"),
    CACHESERVICE("/debug/cacheservice");

    private final String location;
    private final String fullPath;
    private boolean active = false;
    private static DebugTrace myTrace;

    public static void initializeFromOptions(DebugOptions options, boolean pluginIsDebugging) {
        if (pluginIsDebugging) {
            myTrace = options.newDebugTrace("org.eclipse.core.resources.semantic");
            SfsSpiTraceLocation[] sfsSpiTraceLocationArray = SfsSpiTraceLocation.values();
            int n = sfsSpiTraceLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                SfsSpiTraceLocation loc = sfsSpiTraceLocationArray[n2];
                boolean active = options.getBooleanOption(loc.getFullPath(), false);
                loc.setActive(active);
                ++n2;
            }
        } else {
            SfsSpiTraceLocation[] sfsSpiTraceLocationArray = SfsSpiTraceLocation.values();
            int n = sfsSpiTraceLocationArray.length;
            int n3 = 0;
            while (n3 < n) {
                SfsSpiTraceLocation loc = sfsSpiTraceLocationArray[n3];
                loc.setActive(false);
                ++n3;
            }
        }
    }

    private SfsSpiTraceLocation(String path) {
        this.fullPath = "org.eclipse.core.resources.semantic" + path;
        this.location = path;
    }

    public static DebugTrace getTrace() {
        return myTrace;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private String getFullPath() {
        return this.fullPath;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    private void setActive(boolean active) {
        this.active = active;
    }
}

