/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.team;

import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.internal.resources.semantic.team.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticResourceRuleFactory;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class DelegatingResourceRuleFactory
extends ResourceRuleFactory {
    final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

    public DelegatingResourceRuleFactory(ISemanticFileSystem actSfs) {
    }

    public ISchedulingRule charsetRule(IResource resource) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            ISemanticResource sres = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
            if (sres != null) {
                ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)resource.getLocationURI());
                result = this.toRule(new IResource[]{resource}, RuleType.CHARSET, sfs.getEffectiveContentProvider().getRuleFactory().charsetRule(sfs));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result != null && result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return new MultiRule(new ISchedulingRule[]{result, super.charsetRule(resource)});
    }

    public ISchedulingRule copyRule(IResource source, IResource destination) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)destination.getFullPath().toString());
        }
        try {
            ISemanticResource sourceres = (ISemanticResource)source.getAdapter(ISemanticResource.class);
            ISemanticResource desinationres = (ISemanticResource)destination.getAdapter(ISemanticResource.class);
            if (sourceres != null && desinationres != null) {
                ISemanticFileStore sourceStore = (ISemanticFileStore)EFS.getStore((URI)source.getLocationURI());
                ISemanticFileStore destinationStore = (ISemanticFileStore)EFS.getStore((URI)destination.getLocationURI());
                if (sourceStore.getEffectiveContentProvider().getClass().getName().equals(destinationStore.getEffectiveContentProvider().getClass().getName())) {
                    ISchedulingRule iSchedulingRule = this.toRule(new IResource[]{source}, RuleType.COPY, sourceStore.getEffectiveContentProvider().getRuleFactory().copyRule(sourceStore, destinationStore));
                }
                result = this.toRule(new IResource[]{source, destination}, RuleType.COPY, sourceStore.getEffectiveContentProvider().getRuleFactory().copyRule(sourceStore, destinationStore), destinationStore.getEffectiveContentProvider().getRuleFactory().copyRule(sourceStore, destinationStore));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result != null && result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule createRule(IResource resource) {
        ISchedulingRule result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            result = this.calculateRuleForType2(resource, RuleType.CREATE);
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result != null && result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule deleteRule(IResource resource) {
        ISchedulingRule result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            result = this.calculateRuleForType2(resource, RuleType.DELETE);
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result != null && result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule modifyRule(IResource resource) {
        ISchedulingRule superRule;
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            ISemanticResource sres = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
            if (sres != null) {
                ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)resource.getLocationURI());
                result = this.toRule(new IResource[]{resource}, RuleType.MODIFY, sfs.getEffectiveContentProvider().getRuleFactory().modifyRule(sfs));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result != null && result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        if ((superRule = super.modifyRule(resource)).contains((ISchedulingRule)result)) {
            return superRule;
        }
        return result;
    }

    public ISchedulingRule moveRule(IResource source, IResource destination) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), new Object[]{source.getFullPath().toString(), destination.getFullPath().toString()});
        }
        if (!source.getFullPath().segment(0).equals(destination.getFullPath().segment(0))) {
            return new MultiRule(new ISchedulingRule[]{this.modifyRule((IResource)source.getProject()), this.modifyRule((IResource)destination.getProject())});
        }
        try {
            ISemanticResource sourceres = (ISemanticResource)source.getAdapter(ISemanticResource.class);
            ISemanticResource desinationres = (ISemanticResource)destination.getAdapter(ISemanticResource.class);
            if (sourceres != null && desinationres != null) {
                ISemanticFileStore sourceStore = (ISemanticFileStore)EFS.getStore((URI)source.getLocationURI());
                ISemanticFileStore destinationStore = (ISemanticFileStore)EFS.getStore((URI)destination.getLocationURI());
                result = sourceStore.getEffectiveContentProvider().getClass().getName().equals(destinationStore.getEffectiveContentProvider().getClass().getName()) ? this.toRule(new IResource[]{source}, RuleType.MOVE, sourceStore.getEffectiveContentProvider().getRuleFactory().moveRule(sourceStore, destinationStore)) : this.toRule(new IResource[]{source, destination}, RuleType.MOVE, sourceStore.getEffectiveContentProvider().getRuleFactory().moveRule(sourceStore, destinationStore), destinationStore.getEffectiveContentProvider().getRuleFactory().moveRule(sourceStore, destinationStore));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result != null && result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule refreshRule(IResource resource) {
        ISchedulingRule result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            result = this.calculateRuleForType2(resource, RuleType.REFRESH);
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result != null && result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISchedulingRule validateEditRule(IResource[] resources) {
        IWorkspaceRoot result;
        block20: {
            ISemanticFileStore[] stores;
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                Object[] input = new Object[resources.length];
                int i = 0;
                while (i < resources.length) {
                    input[i] = resources[i].getFullPath().toString();
                    ++i;
                }
                SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), input);
            }
            if ((stores = this.allStoresFromSameProvider(resources)) != null) {
                try {
                    ISemanticResource sres = (ISemanticResource)resources[0].getAdapter(ISemanticResource.class);
                    if (sres != null) {
                        result = this.toRule(resources, RuleType.VALIDATE_EDIT, stores[0].getEffectiveContentProvider().getRuleFactory().validateEditRule(stores));
                        break block20;
                    }
                    if (SfsTraceLocation.RULEFACTORY.isActive()) {
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                    }
                    result = this.root;
                }
                catch (CoreException e) {
                    if (SfsTraceLocation.RULEFACTORY.isActive()) {
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
                    }
                    result = this.root;
                }
            } else {
                try {
                    HashSet<ISemanticFileStore> ruleStores = new HashSet<ISemanticFileStore>();
                    IResource[] iResourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource res = iResourceArray[n2];
                        ISemanticResource sres = (ISemanticResource)res.getAdapter(ISemanticResource.class);
                        if (sres != null) {
                            IFileStore fs = EFS.getStore((URI)res.getLocationURI());
                            if (fs instanceof ISemanticFileStore) {
                                ISemanticFileStore sfs = (ISemanticFileStore)fs;
                                ISemanticFileStore ruleStore = sfs.getEffectiveContentProvider().getRuleFactory().validateEditRule(new ISemanticFileStore[]{sfs});
                                if (ruleStore != null) {
                                    ruleStores.add(ruleStore);
                                    ++n2;
                                    continue;
                                }
                                ruleStores.clear();
                                break;
                            }
                            ruleStores.clear();
                            break;
                        }
                        ruleStores.clear();
                        break;
                    }
                    if (ruleStores.isEmpty()) {
                        if (SfsTraceLocation.RULEFACTORY.isActive()) {
                            SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                        }
                        result = this.root;
                    } else {
                        result = this.toRule(resources, RuleType.VALIDATE_EDIT, ruleStores.toArray(new ISemanticFileStore[0]));
                    }
                }
                catch (CoreException e) {
                    if (SfsTraceLocation.RULEFACTORY.isActive()) {
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
                    }
                    result = this.root;
                }
            }
        }
        if (!SfsTraceLocation.RULEFACTORY.isActive()) return result;
        if (result != null && result instanceof IResource) {
            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            return result;
        }
        SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
        return result;
    }

    private ISchedulingRule toRule(IResource[] resources, RuleType type, ISemanticFileStore ... stores) throws CoreException {
        if (stores.length == 1) {
            if (stores[0] == null) {
                return this.root;
            }
            IResource rule = this.getRuleForStore(stores[0], resources[0], type);
            if (rule == null) {
                throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_FOR_STORE_NOT_FOUND, stores[0].getPath(), MessageFormat.format(Messages.DelegatingResourceRuleFactory_NoExistingParentFound_XMSG, stores[0].getPath().toString()));
            }
            return rule;
        }
        ISchedulingRule[] rules = new ISchedulingRule[stores.length];
        int i = 0;
        while (i < stores.length) {
            ISemanticFileStore store = stores[i];
            if (store == null) {
                return this.root;
            }
            IPath path = stores[i].getPath();
            IResource rule = this.root.findMember(path);
            while (!(rule != null && rule.exists() || path.segmentCount() <= 0)) {
                path = path.removeLastSegments(1);
                rule = this.root.findMember(path);
            }
            if (rule == null || !rule.exists()) {
                throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_FOR_STORE_NOT_FOUND, store.getPath(), MessageFormat.format(Messages.DelegatingResourceRuleFactory_NoExistingParentFound_XMSG, stores[0].getPath().toString()));
            }
            rules[i] = rule;
            ++i;
        }
        return new MultiRule(rules);
    }

    private IResource getRuleForStore(ISemanticFileStore store, IResource resource, RuleType type) {
        IResource rule = null;
        Object[] rules = store.getType() == 1 ? this.root.findFilesForLocationURI(store.toURI()) : this.root.findContainersForLocationURI(store.toURI());
        IPath resourcePath = resource.getFullPath();
        int max = 0;
        int i = 0;
        while (i < rules.length) {
            IPath path1 = rules[i].getFullPath();
            int matchingSegments = resourcePath.matchingFirstSegments(path1);
            if (matchingSegments > max) {
                max = matchingSegments;
                rule = rules[i];
            }
            ++i;
        }
        if (rule == null) {
            switch (type) {
                case CREATE: 
                case DELETE: 
                case REFRESH: 
                case MOVE: {
                    rule = resource.getParent();
                    break;
                }
                case MODIFY: {
                    rule = resource;
                    break;
                }
            }
        }
        return rule;
    }

    private ISemanticFileStore[] allStoresFromSameProvider(IResource ... resources) {
        ISemanticFileStore[] result = new ISemanticFileStore[resources.length];
        String lastName = null;
        int i = 0;
        while (i < resources.length) {
            String className;
            block6: {
                IFileStore store;
                block5: {
                    IResource res = resources[i];
                    try {
                        store = EFS.getStore((URI)res.getLocationURI());
                        if (store instanceof ISemanticFileStore) break block5;
                        return null;
                    }
                    catch (CoreException coreException) {
                        return null;
                    }
                }
                result[i] = (ISemanticFileStore)store;
                className = result[i].getEffectiveContentProvider().getClass().getName();
                if (lastName == null || lastName.equals(className)) break block6;
                return null;
            }
            lastName = className;
            ++i;
        }
        return result;
    }

    ISchedulingRule calculateRuleForType(IResource resource, RuleType type) throws CoreException {
        IWorkspaceRoot result;
        ISemanticResource sres = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
        if (sres != null) {
            ISemanticFileStore parentStore;
            ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)resource.getLocationURI());
            ISemanticContentProvider effectiveProvider = sfs.getEffectiveContentProvider();
            ISemanticFileStore rule = effectiveProvider.getRootStore().getPath().equals((Object)sfs.getPath()) ? ((parentStore = (ISemanticFileStore)sfs.getParent()) != null ? this.determineRule(parentStore, type) : this.determineRule(sfs, type)) : this.determineRule(sfs, type);
            result = this.toRule(new IResource[]{resource}, type, rule);
        } else {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
            }
            result = this.root;
        }
        return result;
    }

    private ISemanticFileStore determineRule(ISemanticFileStore sfs, RuleType type) throws CoreException {
        ISemanticContentProvider effectiveProvider = sfs.getEffectiveContentProvider();
        IPath rootStorePath = effectiveProvider.getRootStore().getPath();
        ISemanticResourceRuleFactory factory = effectiveProvider.getRuleFactory();
        ISemanticFileStore rule = this.getRuleForType(factory, type, sfs);
        while (rule != null) {
            IPath rulePath = rule.getPath();
            if (rootStorePath.isPrefixOf(rulePath)) break;
            effectiveProvider = rule.getEffectiveContentProvider();
            rootStorePath = effectiveProvider.getRootStore().getPath();
            factory = effectiveProvider.getRuleFactory();
            rule = this.getRuleForType(factory, type, rule);
        }
        return rule;
    }

    private ISchedulingRule calculateRuleForType2(IResource resource, RuleType type) throws CoreException {
        IWorkspaceRoot result;
        ISemanticResource sres = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
        if (sres != null) {
            ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)resource.getLocationURI());
            ISemanticFileStore rule = this.determineRule2(sfs, type);
            result = this.toRule(new IResource[]{resource}, type, rule);
        } else {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
            }
            result = this.root;
        }
        return result;
    }

    private ISemanticFileStore determineRule2(ISemanticFileStore sfs, RuleType type) throws CoreException {
        ISemanticContentProvider effectiveProvider = sfs.getEffectiveContentProvider();
        ISemanticResourceRuleFactory factory = effectiveProvider.getRuleFactory();
        ISemanticFileStore rule = this.getRuleForType(factory, type, sfs);
        return rule;
    }

    private ISemanticFileStore getRuleForType(ISemanticResourceRuleFactory factory, RuleType type, ISemanticFileStore rule) {
        switch (type) {
            case REFRESH: {
                rule = factory.refreshRule(rule);
                break;
            }
            case CREATE: {
                rule = factory.createRule(rule);
                break;
            }
            case DELETE: {
                rule = factory.deleteRule(rule);
                break;
            }
        }
        return rule;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum RuleType {
        CREATE,
        DELETE,
        MODIFY,
        VALIDATE_EDIT,
        REFRESH,
        CHARSET,
        COPY,
        MOVE;

    }
}

