/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.map;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.map.SimpleMapProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePropertyObservableMap<S, K, V>
extends AbstractObservableMap<K, V>
implements IPropertyObservable<SimpleMapProperty<S, K, V>> {
    private S source;
    private SimpleMapProperty<S, K, V> property;
    private volatile boolean updating = false;
    private volatile int modCount = 0;
    private INativePropertyListener<S> listener;
    private Map<K, V> cachedMap;
    private boolean stale;
    private EntrySet es = new EntrySet();

    public SimplePropertyObservableMap(Realm realm, S source, SimpleMapProperty<S, K, V> property) {
        super(realm);
        this.source = source;
        this.property = property;
    }

    public Object getKeyType() {
        return this.property.getKeyType();
    }

    public Object getValueType() {
        return this.property.getValueType();
    }

    private void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    protected void firstListenerAdded() {
        if (!this.isDisposed()) {
            if (this.listener == null) {
                this.listener = this.property.adaptListener(new ISimplePropertyListener<MapDiff<K, V>>(){

                    @Override
                    public void handleEvent(final SimplePropertyEvent<MapDiff<K, V>> event) {
                        if (!SimplePropertyObservableMap.this.isDisposed() && !SimplePropertyObservableMap.this.updating) {
                            SimplePropertyObservableMap.this.getRealm().exec(new Runnable(){

                                public void run() {
                                    if (event.type == SimplePropertyEvent.CHANGE) {
                                        SimplePropertyObservableMap simplePropertyObservableMap = SimplePropertyObservableMap.this;
                                        simplePropertyObservableMap.modCount = simplePropertyObservableMap.modCount + 1;
                                        SimplePropertyObservableMap.this.notifyIfChanged((MapDiff)event.diff);
                                    } else if (event.type == SimplePropertyEvent.STALE && !SimplePropertyObservableMap.this.stale) {
                                        SimplePropertyObservableMap.this.stale = true;
                                        SimplePropertyObservableMap.this.fireStale();
                                    }
                                }
                            });
                        }
                    }
                });
            }
            this.getRealm().exec(new Runnable(){

                public void run() {
                    SimplePropertyObservableMap.this.cachedMap = new HashMap(SimplePropertyObservableMap.this.getMap());
                    SimplePropertyObservableMap.this.stale = false;
                    if (SimplePropertyObservableMap.this.listener != null) {
                        SimplePropertyObservableMap.this.listener.addTo(SimplePropertyObservableMap.this.source);
                    }
                }
            });
        }
    }

    protected void lastListenerRemoved() {
        if (this.listener != null) {
            this.listener.removeFrom(this.source);
        }
        this.cachedMap.clear();
        this.cachedMap = null;
        this.stale = false;
    }

    private Map<K, V> getMap() {
        return this.property.getMap(this.source);
    }

    private void updateMap(Map<K, V> map, MapDiff<K, V> diff) {
        if (!diff.isEmpty()) {
            boolean wasUpdating = this.updating;
            this.updating = true;
            try {
                this.property.updateMap(this.source, diff);
                ++this.modCount;
            }
            finally {
                this.updating = wasUpdating;
            }
            this.notifyIfChanged(null);
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.getterCalled();
        return this.es;
    }

    public Set<K> keySet() {
        this.getterCalled();
        return super.keySet();
    }

    public boolean containsKey(Object key) {
        this.getterCalled();
        return this.getMap().containsKey(key);
    }

    public V get(Object key) {
        this.getterCalled();
        return this.getMap().get(key);
    }

    public V put(K key, V value) {
        this.checkRealm();
        Map<K, V> map = this.getMap();
        boolean add = !map.containsKey(key);
        V oldValue = map.get(key);
        MapDiff diff = add ? Diffs.createMapDiffSingleAdd(key, value) : Diffs.createMapDiffSingleChange(key, oldValue, value);
        this.updateMap(map, diff);
        return oldValue;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkRealm();
        Map<K, V> map = this.getMap();
        HashMap<K, V> oldValues = new HashMap<K, V>();
        HashMap<K, V> newValues = new HashMap<K, V>();
        HashSet<K> changedKeys = new HashSet<K>();
        HashSet<K> addedKeys = new HashSet<K>();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            K key = entry.getKey();
            V newValue = entry.getValue();
            if (map.containsKey(key)) {
                changedKeys.add(key);
                oldValues.put(key, map.get(key));
            } else {
                addedKeys.add(key);
            }
            newValues.put(key, newValue);
        }
        MapDiff diff = Diffs.createMapDiff(addedKeys, Collections.emptySet(), changedKeys, oldValues, newValues);
        this.updateMap(map, diff);
    }

    public V remove(Object key) {
        this.checkRealm();
        Map<K, V> map = this.getMap();
        if (!map.containsKey(key)) {
            return null;
        }
        V oldValue = map.get(key);
        MapDiff diff = Diffs.createMapDiffSingleRemove((Object)key, oldValue);
        this.updateMap(map, diff);
        return oldValue;
    }

    public void clear() {
        this.getterCalled();
        Map<K, V> map = this.getMap();
        if (map.isEmpty()) {
            return;
        }
        MapDiff diff = Diffs.createMapDiffRemoveAll(new HashMap<K, V>(map));
        this.updateMap(map, diff);
    }

    public Collection<V> values() {
        this.getterCalled();
        return super.values();
    }

    private void notifyIfChanged(MapDiff<K, V> diff) {
        if (this.hasListeners()) {
            Map<K, V> oldMap = this.cachedMap;
            this.cachedMap = new HashMap<K, V>(this.getMap());
            HashMap<K, V> newMap = this.cachedMap;
            if (diff == null) {
                diff = Diffs.computeMapDiff(oldMap, newMap);
            }
            if (!diff.isEmpty() || this.stale) {
                this.stale = false;
                this.fireMapChange(diff);
            }
        }
    }

    public boolean isStale() {
        this.getterCalled();
        return this.stale;
    }

    public Object getObserved() {
        return this.source;
    }

    @Override
    public SimpleMapProperty<S, K, V> getProperty() {
        return this.property;
    }

    public synchronized void dispose() {
        if (!this.isDisposed()) {
            if (this.listener != null) {
                this.listener.removeFrom(this.source);
            }
            this.property = null;
            this.source = null;
            this.listener = null;
            this.stale = false;
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return SimplePropertyObservableMap.this.getMap().size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private volatile int expectedModCount;
        Map<K, V> map;
        Iterator<Map.Entry<K, V>> iterator;
        Map.Entry<K, V> last;

        private EntrySetIterator() {
            this.expectedModCount = SimplePropertyObservableMap.this.modCount;
            this.map = new HashMap(SimplePropertyObservableMap.this.getMap());
            this.iterator = this.map.entrySet().iterator();
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            SimplePropertyObservableMap.this.getterCalled();
            this.checkForComodification();
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            SimplePropertyObservableMap.this.getterCalled();
            this.checkForComodification();
            this.last = this.iterator.next();
            return this.last;
        }

        @Override
        public void remove() {
            SimplePropertyObservableMap.this.getterCalled();
            this.checkForComodification();
            MapDiff diff = Diffs.createMapDiffSingleRemove(this.last.getKey(), this.last.getValue());
            SimplePropertyObservableMap.this.updateMap(this.map, diff);
            this.iterator.remove();
            this.last = null;
            this.expectedModCount = SimplePropertyObservableMap.this.modCount;
        }

        private void checkForComodification() {
            if (this.expectedModCount != SimplePropertyObservableMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

