/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.identity.IdentitySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDetailValueObservableList<M, E>
extends AbstractObservableList<E>
implements IObserving,
RandomAccess {
    private IObservableList<M> masterList;
    private IObservableFactory<? super M, IObservableValue<E>> detailFactory;
    private Object detailType;
    private ArrayList<IObservableValue<E>> detailList;
    private IdentityMap<M, DetailEntry<E>> masterDetailMap = new IdentityMap();
    private IdentitySet<IObservable> staleDetailObservables = new IdentitySet();
    private IListChangeListener<M> masterListListener = new IListChangeListener<M>(){

        @Override
        public void handleListChange(ListChangeEvent<M> event) {
            ListDetailValueObservableList.this.handleMasterListChange(event.diff);
        }
    };
    private IValueChangeListener<E> detailValueListener = new IValueChangeListener<E>(){

        @Override
        public void handleValueChange(ValueChangeEvent<E> event) {
            if (!event.getObservable().isStale()) {
                ListDetailValueObservableList.this.staleDetailObservables.remove(event.getObservable());
            }
            ListDetailValueObservableList.this.handleDetailValueChange(event);
        }
    };
    private IStaleListener masterStaleListener = new IStaleListener(){

        public void handleStale(StaleEvent staleEvent) {
            ListDetailValueObservableList.this.fireStale();
        }
    };
    private IStaleListener detailStaleListener = new IStaleListener(){

        public void handleStale(StaleEvent staleEvent) {
            boolean wasStale = ListDetailValueObservableList.this.isStale();
            ListDetailValueObservableList.this.staleDetailObservables.add(staleEvent.getObservable());
            if (!wasStale) {
                ListDetailValueObservableList.this.fireStale();
            }
        }
    };

    public ListDetailValueObservableList(IObservableList<M> masterList, IObservableFactory<? super M, IObservableValue<E>> detailFactory, Object detailType) {
        super(masterList.getRealm());
        this.masterList = masterList;
        this.detailFactory = detailFactory;
        this.detailType = detailType;
        this.detailList = new ArrayList();
        masterList.addListChangeListener(this.masterListListener);
        masterList.addStaleListener(this.masterStaleListener);
        masterList.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
                ListDetailValueObservableList.this.dispose();
            }
        });
        List emptyList = Collections.emptyList();
        ListDiff initMasterDiff = Diffs.computeListDiff(emptyList, masterList);
        this.handleMasterListChange(initMasterDiff);
    }

    @Override
    protected synchronized void firstListenerAdded() {
        int i = 0;
        while (i < this.detailList.size()) {
            IObservableValue<E> detail = this.detailList.get(i);
            detail.addValueChangeListener(this.detailValueListener);
            detail.addStaleListener(this.detailStaleListener);
            if (detail.isStale()) {
                this.staleDetailObservables.add(detail);
            }
            ++i;
        }
    }

    @Override
    protected synchronized void lastListenerRemoved() {
        if (this.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.detailList.size()) {
            IObservableValue<E> detail = this.detailList.get(i);
            detail.removeValueChangeListener(this.detailValueListener);
            detail.removeStaleListener(this.detailStaleListener);
            ++i;
        }
        this.staleDetailObservables.clear();
    }

    private void handleMasterListChange(ListDiff<M> masterListDiff) {
        boolean wasStale = this.isStale();
        boolean hasListeners = this.hasListeners();
        List<ListDiffEntry<M>> masterEntries = masterListDiff.getDifferencesAsList();
        ArrayList<ListDiffEntry<ListDiffEntry<E>>> detailEntries = new ArrayList<ListDiffEntry<ListDiffEntry<E>>>(masterEntries.size());
        int i = 0;
        while (i < masterEntries.size()) {
            ListDiffEntry<M> masterEntry = masterEntries.get(i);
            int index = masterEntry.getPosition();
            M masterElement = masterEntry.getElement();
            E detailValue = masterEntry.isAddition() ? this.addDetailObservable(masterElement, index) : this.removeDetailObservable(masterElement, index);
            if (hasListeners) {
                detailEntries.add(Diffs.createListDiffEntry(index, masterEntry.isAddition(), detailValue));
            } else {
                detailEntries.add(null);
            }
            ++i;
        }
        if (hasListeners) {
            if (!wasStale && this.isStale()) {
                this.fireStale();
            }
            this.fireListChange(Diffs.createListDiff(detailEntries));
        }
    }

    private E addDetailObservable(M masterElement, int index) {
        DetailEntry<E> detailEntry = this.masterDetailMap.get(masterElement);
        if (detailEntry != null) {
            DetailEntry<E> detailEntry2 = detailEntry;
            ((DetailEntry)detailEntry2).masterReferenceCount = ((DetailEntry)detailEntry2).masterReferenceCount + 1;
            this.detailList.add(index, ((DetailEntry)detailEntry).detailObservable);
            return (E)((DetailEntry)detailEntry).detailObservable.getValue();
        }
        IObservableValue<E> detail = this.createDetailObservable(masterElement);
        this.masterDetailMap.put(masterElement, new DetailEntry<E>(detail));
        this.detailList.add(index, detail);
        if (this.hasListeners()) {
            detail.addValueChangeListener(this.detailValueListener);
            detail.addStaleListener(this.detailStaleListener);
            if (detail.isStale()) {
                this.staleDetailObservables.add(detail);
            }
        }
        return detail.getValue();
    }

    private E removeDetailObservable(Object masterElement, int index) {
        DetailEntry<E> detailEntry;
        IObservableValue<E> detail = this.detailList.remove(index);
        E detailValue = detail.getValue();
        DetailEntry<E> detailEntry2 = detailEntry = this.masterDetailMap.get(masterElement);
        ((DetailEntry)detailEntry2).masterReferenceCount = ((DetailEntry)detailEntry2).masterReferenceCount - 1;
        if (((DetailEntry)detailEntry).masterReferenceCount == 0) {
            this.masterDetailMap.remove(masterElement);
            this.staleDetailObservables.remove(detail);
            detail.dispose();
        }
        return detailValue;
    }

    private void handleDetailValueChange(ValueChangeEvent<E> event) {
        IObservableValue<E> detail = event.getObservableValue();
        BitSet detailIndexes = new BitSet();
        int i = 0;
        while (i < this.detailList.size()) {
            if (this.detailList.get(i) == detail) {
                detailIndexes.set(i);
            }
            ++i;
        }
        Object oldValue = event.diff.getOldValue();
        Object newValue = event.diff.getNewValue();
        ArrayList diffEntries = new ArrayList(2 * detailIndexes.cardinality());
        int b = detailIndexes.nextSetBit(0);
        while (b != -1) {
            diffEntries.add(Diffs.createListDiffEntry(b, false, oldValue));
            diffEntries.add(Diffs.createListDiffEntry(b, true, newValue));
            b = detailIndexes.nextSetBit(b + 1);
        }
        this.fireListChange(Diffs.createListDiff(diffEntries));
    }

    private IObservableValue<E> createDetailObservable(M masterElement) {
        ObservableTracker.setIgnore(true);
        try {
            IObservableValue<E> iObservableValue = this.detailFactory.createObservable(masterElement);
            return iObservableValue;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    protected int doGetSize() {
        return this.detailList.size();
    }

    @Override
    public E get(int index) {
        ObservableTracker.getterCalled(this);
        return this.detailList.get(index).getValue();
    }

    @Override
    public E set(int index, E element) {
        IObservableValue<E> detail = this.detailList.get(index);
        E oldElement = detail.getValue();
        detail.setValue(element);
        return oldElement;
    }

    @Override
    public E move(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getElementType() {
        return this.detailType;
    }

    @Override
    public boolean isStale() {
        return super.isStale() || this.masterList != null && this.masterList.isStale() || this.staleDetailObservables != null && !this.staleDetailObservables.isEmpty();
    }

    @Override
    public Object getObserved() {
        return this.masterList;
    }

    @Override
    public synchronized void dispose() {
        if (this.masterList != null) {
            this.masterList.removeListChangeListener(this.masterListListener);
            this.masterList.removeStaleListener(this.masterStaleListener);
        }
        if (this.detailList != null) {
            for (IObservableValue<E> detailValue : this.detailList) {
                detailValue.dispose();
            }
            this.detailList.clear();
        }
        this.masterList = null;
        this.detailFactory = null;
        this.detailType = null;
        this.masterListListener = null;
        this.detailValueListener = null;
        this.masterDetailMap = null;
        this.staleDetailObservables = null;
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DetailEntry<E> {
        private final IObservableValue<E> detailObservable;
        private int masterReferenceCount = 1;

        public DetailEntry(IObservableValue<E> detailObservable) {
            this.detailObservable = detailObservable;
        }
    }
}

