/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.LSApplicationParameters;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.cocoa.Cocoa;

public final class Program {
    String name;
    byte[] fsRef;
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";

    Program() {
    }

    public static Program findProgram(String extension) {
        char[] chars;
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            chars = new char[extension.length()];
            extension.getChars(0, chars.length, chars, 0);
        } else {
            chars = new char[extension.length() - 1];
            extension.getChars(1, extension.length(), chars, 0);
        }
        int ext = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        Program program = null;
        if (ext != 0) {
            byte[] fsRef = new byte[80];
            if (OS.LSGetApplicationForInfo(0, 0, ext, -1, fsRef, null) == 0) {
                program = Program.getProgram(fsRef);
            }
            OS.CFRelease(ext);
        }
        return program;
    }

    public static String[] getExtensions() {
        char[] chars = new char["CFBundleDocumentTypes".length()];
        "CFBundleDocumentTypes".getChars(0, chars.length, chars, 0);
        int CFBundleDocumentTypes = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        chars = new char["CFBundleTypeExtensions".length()];
        "CFBundleTypeExtensions".getChars(0, chars.length, chars, 0);
        int CFBundleTypeExtensions = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        int folders = Cocoa.NSSearchPathForDirectoriesInDomains(100, 65535, true);
        int folderCount = OS.CFArrayGetCount(folders);
        int supportedDocumentTypes = OS.CFSetCreateMutable(0, 0, OS.kCFTypeSetCallBacks());
        int i = 0;
        while (i < folderCount) {
            int string = OS.CFArrayGetValueAtIndex(folders, i);
            int folderUrl = OS.CFURLCreateWithFileSystemPath(0, string, 0, true);
            if (folderUrl != 0) {
                int bundles = OS.CFBundleCreateBundlesFromDirectory(0, folderUrl, 0);
                if (bundles != 0) {
                    int bundleCount = OS.CFArrayGetCount(bundles);
                    int j = 0;
                    while (j < bundleCount) {
                        int documentTypes;
                        int bundleRef = OS.CFArrayGetValueAtIndex(bundles, j);
                        if (bundleRef != 0 && (documentTypes = OS.CFBundleGetValueForInfoDictionaryKey(bundleRef, CFBundleDocumentTypes)) != 0) {
                            int count = OS.CFArrayGetCount(documentTypes);
                            int k = 0;
                            while (k < count) {
                                int[] value;
                                int documentType = OS.CFArrayGetValueAtIndex(documentTypes, k);
                                if (documentType != 0 && OS.CFDictionaryGetValueIfPresent(documentType, CFBundleTypeExtensions, value = new int[1]) && value[0] != 0) {
                                    int extCount = OS.CFArrayGetCount(value[0]);
                                    int x = 0;
                                    while (x < extCount) {
                                        int ext = OS.CFArrayGetValueAtIndex(value[0], x);
                                        OS.CFSetAddValue(supportedDocumentTypes, ext);
                                        ++x;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    OS.CFRelease(bundles);
                }
                OS.CFRelease(folderUrl);
            }
            ++i;
        }
        OS.CFRelease(CFBundleDocumentTypes);
        OS.CFRelease(CFBundleTypeExtensions);
        int s = OS.CFStringCreateWithCharacters(0, new char[]{'*'}, 1);
        OS.CFSetRemoveValue(supportedDocumentTypes, s);
        OS.CFRelease(s);
        int count = OS.CFSetGetCount(supportedDocumentTypes);
        String[] extensions = new String[count];
        int[] values = new int[count];
        OS.CFSetGetValues(supportedDocumentTypes, values);
        int i2 = 0;
        while (i2 < count) {
            int ext = values[i2];
            int length = OS.CFStringGetLength(ext);
            char[] buffer = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(ext, range, buffer);
            extensions[i2] = "." + new String(buffer);
            ++i2;
        }
        OS.CFRelease(supportedDocumentTypes);
        return extensions;
    }

    public static Program[] getPrograms() {
        Hashtable<String, Program> bundles = new Hashtable<String, Program>();
        String[] extensions = Program.getExtensions();
        byte[] fsRef = new byte[80];
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            char[] chars = new char[extension.length() - 1];
            extension.getChars(1, extension.length(), chars, 0);
            int ext = OS.CFStringCreateWithCharacters(0, chars, chars.length);
            if (ext != 0) {
                int utis;
                Program program;
                if (OS.LSGetApplicationForInfo(0, 0, ext, -1, fsRef, null) == 0 && (program = Program.getProgram(fsRef)) != null && bundles.get(program.getName()) == null) {
                    bundles.put(program.getName(), program);
                    fsRef = new byte[80];
                }
                if (OS.VERSION >= 4160 && (utis = OS.UTTypeCreateAllIdentifiersForTag(OS.kUTTagClassFilenameExtension(), ext, 0)) != 0) {
                    int utiCount = OS.CFArrayGetCount(utis);
                    int j = 0;
                    while (j < utiCount) {
                        int apps;
                        int uti = OS.CFArrayGetValueAtIndex(utis, j);
                        if (uti != 0 && (apps = OS.LSCopyAllRoleHandlersForContentType(uti, -1)) != 0) {
                            int appCount = OS.CFArrayGetCount(apps);
                            int k = 0;
                            while (k < appCount) {
                                Program program2;
                                int app = OS.CFArrayGetValueAtIndex(apps, k);
                                if (app != 0 && OS.LSFindApplicationForInfo(0, app, 0, fsRef, null) == 0 && (program2 = Program.getProgram(fsRef)) != null && bundles.get(program2.getName()) == null) {
                                    bundles.put(program2.getName(), program2);
                                    fsRef = new byte[80];
                                }
                                ++k;
                            }
                            OS.CFRelease(apps);
                        }
                        ++j;
                    }
                    OS.CFRelease(utis);
                }
                OS.CFRelease(ext);
            }
            ++i;
        }
        int count = 0;
        Program[] programs = new Program[bundles.size()];
        Enumeration values = bundles.elements();
        while (values.hasMoreElements()) {
            programs[count++] = (Program)values.nextElement();
        }
        return programs;
    }

    static int getURL(String fileName) {
        int urlstr;
        int url;
        char[] chars = new char[fileName.length()];
        fileName.getChars(0, chars.length, chars, 0);
        int str = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        if (str == 0) {
            return 0;
        }
        int file = str;
        int fileManager = Cocoa.objc_msgSend(Cocoa.C_NSFileManager, Cocoa.S_defaultManager);
        if (fileManager != 0 && Cocoa.objc_msgSend(fileManager, Cocoa.S_fileExistsAtPath, str) != 0 && (url = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_fileURLWithPath, str)) != 0 && (urlstr = Cocoa.objc_msgSend(url, Cocoa.S_absoluteString)) != 0) {
            file = urlstr;
        }
        char[] unescapedChars = new char[]{'%'};
        String lowercaseName = fileName.toLowerCase();
        if (lowercaseName.startsWith(PREFIX_HTTP) || lowercaseName.startsWith(PREFIX_HTTPS)) {
            unescapedChars = new char[]{'%', '#'};
        }
        int unescapedStr = OS.CFStringCreateWithCharacters(0, unescapedChars, unescapedChars.length);
        int escapedStr = OS.CFURLCreateStringByAddingPercentEscapes(0, file, unescapedStr, 0, 0x8000100);
        int url2 = 0;
        if (escapedStr != 0) {
            url2 = OS.CFURLCreateWithString(0, escapedStr, 0);
            OS.CFRelease(escapedStr);
        }
        if (unescapedStr != 0) {
            OS.CFRelease(unescapedStr);
        }
        OS.CFRelease(str);
        return url2;
    }

    static boolean isExecutable(String fileName) {
        boolean result = false;
        int str = Program.createCFString(fileName);
        if (str != 0) {
            int fileManager = Cocoa.objc_msgSend(Cocoa.C_NSFileManager, Cocoa.S_defaultManager);
            int ptr = OS.malloc(1);
            if (ptr != 0) {
                if (fileManager != 0 && Cocoa.objc_msgSend(fileManager, Cocoa.S_fileExistsAtPath_isDirectory, str, ptr) != 0) {
                    int url;
                    byte[] isDirectory = new byte[1];
                    OS.memmove(isDirectory, ptr, 1);
                    if (isDirectory[0] == 0 && Cocoa.objc_msgSend(fileManager, Cocoa.S_isExecutableFileAtPath, str) != 0 && (url = OS.CFURLCreateWithFileSystemPath(0, str, 0, false)) != 0) {
                        byte[] fsRef = new byte[80];
                        if (OS.CFURLGetFSRef(url, fsRef)) {
                            int[] type = new int[1];
                            OS.LSCopyItemAttribute(fsRef, -1, OS.kLSItemContentType(), type);
                            if (type[0] != 0) {
                                int exeUti = Program.createCFString("public.unix-executable");
                                result = OS.UTTypeConformsTo(type[0], exeUti);
                                OS.CFRelease(exeUti);
                                if (!result) {
                                    int scriptUti = Program.createCFString("public.shell-script");
                                    result = OS.UTTypeEqual(type[0], scriptUti);
                                    OS.CFRelease(scriptUti);
                                }
                                OS.CFRelease(type[0]);
                            }
                        }
                        OS.CFRelease(url);
                    }
                }
                OS.free(ptr);
            }
            OS.CFRelease(str);
        }
        return result;
    }

    static int createCFString(String string) {
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        return OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
    }

    public static boolean launch(String fileName) {
        return Program.launch(fileName, null);
    }

    public static boolean launch(String fileName, String workingDir) {
        if (fileName == null) {
            SWT.error(4);
        }
        if (workingDir != null && Program.isExecutable(fileName)) {
            try {
                Compatibility.exec(new String[]{fileName}, null, workingDir);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        int rc = -1;
        int url = Program.getURL(fileName);
        if (url != 0) {
            rc = OS.LSOpenCFURLRef(url, null);
            OS.CFRelease(url);
        }
        return rc == 0;
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        if (OS.VERSION < 4160) {
            return Program.launch(fileName);
        }
        int rc = -1;
        int fsRefPtr = OS.NewPtr(this.fsRef.length);
        if (fsRefPtr != 0) {
            OS.memmove(fsRefPtr, this.fsRef, this.fsRef.length);
            LSApplicationParameters params = new LSApplicationParameters();
            params.version = 0;
            params.flags = 0;
            params.application = fsRefPtr;
            if (fileName.length() == 0) {
                rc = OS.LSOpenApplication(params, null);
            } else {
                int url = Program.getURL(fileName);
                if (url != 0) {
                    int urls = OS.CFArrayCreateMutable(0, 1, OS.kCFTypeArrayCallBacks());
                    if (urls != 0) {
                        OS.CFArrayAppendValue(urls, url);
                        rc = OS.LSOpenURLsWithRole(urls, -1, 0, params, null, 0);
                        OS.CFRelease(urls);
                    }
                    OS.CFRelease(url);
                }
            }
            OS.DisposePtr(fsRefPtr);
        }
        return rc == 0;
    }

    ImageData createImageFromFamily(int family, int type, int maskType, int width, int height) {
        int dataHandle = OS.NewHandle(0);
        int result = OS.GetIconFamilyData(family, type, dataHandle);
        if (result != 0) {
            OS.DisposeHandle(dataHandle);
            return null;
        }
        int maskHandle = OS.NewHandle(0);
        result = OS.GetIconFamilyData(family, maskType, maskHandle);
        if (result != 0) {
            OS.DisposeHandle(maskHandle);
            OS.DisposeHandle(dataHandle);
            return null;
        }
        int dataSize = OS.GetHandleSize(dataHandle);
        OS.HLock(dataHandle);
        OS.HLock(maskHandle);
        int[] iconPtr = new int[1];
        int[] maskPtr = new int[1];
        OS.memmove(iconPtr, dataHandle, 4);
        OS.memmove(maskPtr, maskHandle, 4);
        byte[] data = new byte[dataSize];
        OS.memmove(data, iconPtr[0], dataSize);
        byte[] alphaData = new byte[width * height];
        OS.memmove(alphaData, maskPtr[0], alphaData.length);
        OS.HUnlock(maskHandle);
        OS.HUnlock(dataHandle);
        OS.DisposeHandle(maskHandle);
        OS.DisposeHandle(dataHandle);
        ImageData image = new ImageData(width, height, 32, new PaletteData(0xFF0000, 65280, 255), 4, data);
        image.alphaData = alphaData;
        return image;
    }

    public ImageData getImageData() {
        int[] iconRef = new int[1];
        OS.GetIconRefFromFileInfo(this.fsRef, 0, null, 0, 0, 0, iconRef, null);
        int[] family = new int[1];
        int rc = OS.IconRefToIconFamily(iconRef[0], -1, family);
        OS.ReleaseIconRef(iconRef[0]);
        if (rc != 0) {
            return null;
        }
        ImageData result = this.createImageFromFamily(family[0], 1769157426, 1933077867, 16, 16);
        OS.DisposeHandle(family[0]);
        if (result == null) {
            RGB[] rgbs = new RGB[]{new RGB(255, 255, 255), new RGB(95, 95, 95), new RGB(128, 128, 128), new RGB(192, 192, 192), new RGB(223, 223, 191), new RGB(255, 223, 159), new RGB(0, 0, 0)};
            result = new ImageData(16, 16, 4, new PaletteData(rgbs));
            result.transparentPixel = 6;
            String[] p = new String[]{"CCCCCCCCGGG", "CFAAAAACBGG", "CAAAAAACFBG", "CAAAAAACBBB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CDDDDDDDDDB", "CBBBBBBBBBB"};
            int y = 0;
            while (y < p.length) {
                int x = 0;
                while (x < 11) {
                    result.setPixel(x + 3, y + 1, p[y].charAt(x) - 65);
                    ++x;
                }
                ++y;
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    static Program getProgram(byte[] fsRef) {
        String name = "";
        int[] namePtr = new int[1];
        OS.LSCopyDisplayNameForRef(fsRef, namePtr);
        if (namePtr[0] != 0) {
            int length = OS.CFStringGetLength(namePtr[0]);
            if (length != 0) {
                char[] buffer = new char[length];
                CFRange range = new CFRange();
                range.length = length;
                OS.CFStringGetCharacters(namePtr[0], range, buffer);
                name = new String(buffer);
            }
            OS.CFRelease(namePtr[0]);
        }
        Program program = new Program();
        program.fsRef = fsRef;
        program.name = name;
        return program;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

