/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewArchiveDialog
extends StatusDialog {
    private IStatus fErrorStatus;
    private IStatus fOkStatus;
    private Text fPathText;
    private ISiteArchive fSiteArchive;
    private ISiteModel fSiteModel;
    private Text fUrlText;

    public NewArchiveDialog(Shell shell, ISiteModel siteModel, ISiteArchive archive) {
        super(shell);
        this.fSiteModel = siteModel;
        this.fSiteArchive = archive;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.dialogChanged();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createEntries(container);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewArchiveDialog.this.dialogChanged();
            }
        };
        this.fPathText.addModifyListener(listener);
        this.fUrlText.addModifyListener(listener);
        this.setTitle(PDEUIMessages.SiteEditor_NewArchiveDialog_title);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.new_archive_dialog");
        return container;
    }

    private void createEntries(Composite container) {
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.SiteEditor_NewArchiveDialog_path);
        this.fPathText = new Text(container, 2052);
        this.fPathText.setLayoutData((Object)new GridData(768));
        label = new Label(container, 0);
        label.setText(PDEUIMessages.SiteEditor_NewArchiveDialog_url);
        this.fUrlText = new Text(container, 2052);
        this.fUrlText.setLayoutData((Object)new GridData(768));
        if (this.fSiteArchive != null) {
            this.setIfDefined(this.fUrlText, this.fSiteArchive.getURL());
            this.setIfDefined(this.fPathText, this.fSiteArchive.getPath());
        }
    }

    private IStatus createErrorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 0, message, null);
    }

    private void dialogChanged() {
        IStatus status = null;
        if (this.fUrlText.getText().length() == 0 || this.fPathText.getText().length() == 0) {
            status = this.getEmptyErrorStatus();
        } else if (this.hasPath(this.fPathText.getText())) {
            status = this.createErrorStatus(PDEUIMessages.NewArchiveDialog_alreadyExists);
        }
        if (status == null) {
            status = this.getOKStatus();
        }
        this.updateStatus(status);
    }

    private void execute() {
        boolean add;
        boolean bl = add = this.fSiteArchive == null;
        if (this.fSiteArchive == null) {
            this.fSiteArchive = this.fSiteModel.getFactory().createArchive();
        }
        try {
            this.fSiteArchive.setURL(this.fUrlText.getText());
            this.fSiteArchive.setPath(this.fPathText.getText());
            if (add) {
                this.fSiteModel.getSite().addArchives(new ISiteArchive[]{this.fSiteArchive});
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IStatus getEmptyErrorStatus() {
        if (this.fErrorStatus == null) {
            this.fErrorStatus = this.createErrorStatus(PDEUIMessages.SiteEditor_NewArchiveDialog_error);
        }
        return this.fErrorStatus;
    }

    private IStatus getOKStatus() {
        if (this.fOkStatus == null) {
            this.fOkStatus = new Status(0, PDEPlugin.getPluginId(), 0, "", null);
        }
        return this.fOkStatus;
    }

    private boolean hasPath(String path) {
        String currentPath = this.fSiteArchive != null ? this.fSiteArchive.getPath() : null;
        ISiteModel model = this.fSiteModel;
        ISiteArchive[] archives = model.getSite().getArchives();
        int i = 0;
        while (i < archives.length) {
            ISiteArchive archive = archives[i];
            String apath = archive.getPath();
            if (currentPath != null && currentPath.equals(path)) {
                return false;
            }
            if (apath != null && apath.equals(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void okPressed() {
        this.execute();
        super.okPressed();
    }

    private void setIfDefined(Text text, String value) {
        if (value != null) {
            text.setText(value);
        }
    }
}

