/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportRewriteUtil {
    public static void addImports(CompilationUnitRewrite rewrite, ImportRewrite.ImportRewriteContext context, ASTNode node, Map<Name, String> typeImports, Map<Name, String> staticImports, boolean declarations) {
        ImportRewriteUtil.addImports(rewrite, context, node, typeImports, staticImports, null, declarations);
    }

    public static void addImports(CompilationUnitRewrite rewrite, ImportRewrite.ImportRewriteContext context, ASTNode node, Map<Name, String> typeImports, Map<Name, String> staticImports, Collection<IBinding> excludeBindings, boolean declarations) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)node);
        Assert.isNotNull(typeImports);
        Assert.isNotNull(staticImports);
        HashSet<SimpleName> types = new HashSet<SimpleName>();
        HashSet<SimpleName> members = new HashSet<SimpleName>();
        ImportReferencesCollector.collect(node, rewrite.getCu().getJavaProject(), null, declarations, types, members);
        ImportRewrite rewriter = rewrite.getImportRewrite();
        ImportRemover remover = rewrite.getImportRemover();
        Object var11_11 = null;
        IBinding binding = null;
        for (Name name : types) {
            binding = name.resolveBinding();
            if (!(binding instanceof ITypeBinding)) continue;
            ITypeBinding type = (ITypeBinding)binding;
            if (excludeBindings != null && excludeBindings.contains(type)) continue;
            typeImports.put(name, rewriter.addImport(type, context));
            remover.registerAddedImport(((SimpleName)name).getIdentifier());
        }
        for (Name name : members) {
            IMethodBinding method;
            ITypeBinding declaring;
            binding = name.resolveBinding();
            if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                declaring = variable.getDeclaringClass();
                if (declaring == null || excludeBindings != null && excludeBindings.contains(variable)) continue;
                staticImports.put(name, rewriter.addStaticImport((IBinding)variable, context));
                remover.registerAddedStaticImport(declaring.getQualifiedName(), variable.getName(), true);
                continue;
            }
            if (!(binding instanceof IMethodBinding) || (declaring = (method = (IMethodBinding)binding).getDeclaringClass()) == null || excludeBindings != null && excludeBindings.contains(method)) continue;
            staticImports.put(name, rewriter.addStaticImport((IBinding)method, context));
            remover.registerAddedStaticImport(declaring.getQualifiedName(), method.getName(), false);
        }
    }

    public static void collectImports(IJavaProject project, ASTNode node, Collection<ITypeBinding> typeBindings, Collection<IBinding> staticBindings, boolean declarations) {
        ImportRewriteUtil.collectImports(project, node, typeBindings, staticBindings, null, declarations);
    }

    public static void collectImports(IJavaProject project, ASTNode node, Collection<ITypeBinding> typeBindings, Collection<IBinding> staticBindings, Collection<IBinding> excludeBindings, boolean declarations) {
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)node);
        Assert.isNotNull(typeBindings);
        Assert.isNotNull(staticBindings);
        HashSet<SimpleName> types = new HashSet<SimpleName>();
        HashSet<SimpleName> members = new HashSet<SimpleName>();
        ImportReferencesCollector.collect(node, project, null, declarations, types, members);
        Object var8_8 = null;
        IBinding binding = null;
        for (Name name : types) {
            binding = name.resolveBinding();
            if (!(binding instanceof ITypeBinding)) continue;
            ITypeBinding type = (ITypeBinding)binding;
            if (excludeBindings != null && excludeBindings.contains(type)) continue;
            typeBindings.add(type);
        }
        for (Name name : members) {
            binding = name.resolveBinding();
            if (binding == null || excludeBindings != null && excludeBindings.contains(binding)) continue;
            staticBindings.add(binding);
        }
    }

    private ImportRewriteUtil() {
    }
}

