/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.actions.ShowInNavigatorViewAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ButtonAttributeRow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceAttributeRow
extends ButtonAttributeRow {
    public ResourceAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    protected boolean isReferenceModel() {
        return !this.part.getPage().getModel().isEditable();
    }

    protected void openReference() {
        IResource file = this.getFile();
        boolean successful = false;
        if (file instanceof IFile) {
            successful = this.openFile((IFile)file);
        } else if (file instanceof IContainer) {
            successful = this.openContainer((IContainer)file);
        }
        if (!successful) {
            Display.getCurrent().beep();
        }
    }

    private boolean openFile(IFile file) {
        if (file != null && file.exists()) {
            try {
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                PDEPlugin.logException(e);
                return false;
            }
            return true;
        }
        file = this.getNLFile();
        if (file != null && file.exists()) {
            try {
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                PDEPlugin.logException(e);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean openContainer(IContainer container) {
        if (container != null && container.exists()) {
            try {
                IViewPart part = PDEPlugin.getActivePage().showView("org.eclipse.ui.views.ResourceNavigator");
                ShowInNavigatorViewAction action = new ShowInNavigatorViewAction((IWorkbenchSite)part.getSite());
                action.run((IResource)container);
            }
            catch (PartInitException partInitException) {
                return false;
            }
        }
        return true;
    }

    private IResource getFile() {
        String value = this.text.getText();
        if (value.length() == 0) {
            return null;
        }
        IPath path = this.getProject().getFullPath().append(value);
        return this.getProject().getWorkspace().getRoot().findMember(path);
    }

    private IFile getNLFile() {
        String value = this.text.getText();
        if (value.length() <= 5 || !value.startsWith("$nl$/")) {
            return null;
        }
        IPath path = this.getProject().getFullPath().append(value.substring(5));
        return this.getProject().getWorkspace().getRoot().getFile(path);
    }

    protected void browse() {
        final IProject project = this.part.getPage().getPDEEditor().getCommonProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)project.getWorkspace());
        IResource resource = this.getFile();
        if (resource != null) {
            dialog.setInitialSelection((Object)resource);
        }
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)project);
                }
                return true;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.ResourceAttributeCellEditor_title);
        dialog.setMessage(PDEUIMessages.ResourceAttributeCellEditor_message);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && (selection[0] instanceof IFile || selection[0] instanceof IContainer)) {
                    return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
                }
                return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            IPath path = res.getProjectRelativePath();
            if (res instanceof IContainer) {
                path = path.addTrailingSeparator();
            }
            String value = path.toString();
            this.text.setText(value);
        }
    }
}

