/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductObject;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.wizards.product.ISplashHandlerConstants;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SplashConfigurationSection
extends PDESection {
    private static final int F_NUM_COLUMNS = 10;
    private ColorSelector fColorSelector;
    private boolean fBlockNotification;
    private Button fAddBarButton;
    private Spinner[] fBarSpinners = new Spinner[4];
    private Control[] fBarControls = new Control[8];
    private Button fAddMessageButton;
    private Spinner[] fMessageSpinners = new Spinner[4];
    private Control[] fMessageControls = new Control[10];
    private Section fSection;
    private FormToolkit fToolkit;
    private ComboPart fFieldTemplateCombo = null;
    private ControlDecoration fControlDecoration = null;

    public SplashConfigurationSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        this.fSection = section;
        this.fToolkit = toolkit;
        this.configureUISection();
        this.createUI();
        this.createUIListenersFieldTemplateCombo();
    }

    private void createUIListenersFieldTemplateCombo() {
        this.fFieldTemplateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SplashConfigurationSection.this.handleTemplateComboWidgetSelected();
            }
        });
        this.fFieldTemplateCombo.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                double currentTarget = TargetPlatformHelper.getTargetVersion();
                if (currentTarget <= 3.2) {
                    SplashConfigurationSection.this.fControlDecoration.show();
                }
            }

            public void focusLost(FocusEvent e) {
                SplashConfigurationSection.this.fControlDecoration.hide();
            }
        });
    }

    private void handleTemplateComboWidgetSelected() {
        if (this.fBlockNotification) {
            return;
        }
        String template = this.getSelectedTemplate();
        this.getSplashInfo().setFieldSplashHandlerType(template, false);
        this.updateFieldEnablement();
    }

    private String getSelectedTemplate() {
        int index = this.fFieldTemplateCombo.getSelectionIndex();
        int position = index - 1;
        if (index <= 0 || index > ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES.length) {
            return null;
        }
        return ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES[position][0];
    }

    private void createUI() {
        Composite container = this.createUISectionContainer((Composite)this.fSection);
        this.createUILabelType(container);
        this.createUIFieldTemplateCombo(container);
        this.createUIFieldDecorationTemplate();
        this.createUILabelProgress(container);
        this.createProgressBarConfig(container);
        this.createProgressMessageConfig(container);
        this.fToolkit.paintBordersFor(container);
        this.fSection.setClient((Control)container);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private void createUIFieldDecorationTemplate() {
        int bits = 16512;
        this.fControlDecoration = new ControlDecoration(this.fFieldTemplateCombo.getControl(), bits);
        this.fControlDecoration.setMarginWidth(0);
        this.fControlDecoration.setDescriptionText(PDEUIMessages.SplashConfigurationSection_msgDecorationTemplateSupport);
        this.fControlDecoration.setShowHover(true);
        FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        this.fControlDecoration.setImage(contentProposalImage.getImage());
        this.fControlDecoration.hide();
    }

    private void createUILabelType(Composite parent) {
        Color foreground = this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        Label label = this.fToolkit.createLabel(parent, PDEUIMessages.SplashTemplatesSection_typeName, 64);
        label.setForeground(foreground);
    }

    private void createUILabelProgress(Composite parent) {
        Label label = this.fToolkit.createLabel(parent, PDEUIMessages.SplashConfigurationSection_sectionDescCustomization, 64);
        GridData data = new GridData(768);
        data.horizontalSpan = 10;
        data.verticalIndent = 5;
        label.setLayoutData((Object)data);
    }

    private void createUIFieldTemplateCombo(Composite parent) {
        int style = 2056;
        this.fFieldTemplateCombo = new ComboPart();
        this.fFieldTemplateCombo.createControl(parent, this.fToolkit, style);
        GridData data = new GridData(768);
        data.horizontalSpan = 9;
        this.fFieldTemplateCombo.getControl().setLayoutData((Object)data);
        this.fFieldTemplateCombo.add(PDEUIMessages.SplashConfigurationSection_none, 0);
        int i = 0;
        while (i < ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES.length) {
            int position = i + 1;
            this.fFieldTemplateCombo.add(ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES[i][1], position);
            ++i;
        }
    }

    private Composite createUISectionContainer(Composite parent) {
        Composite client = this.fToolkit.createComposite((Composite)this.fSection);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 10));
        client.setLayoutData((Object)new GridData(768));
        return client;
    }

    private void configureUISection() {
        this.fSection.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        this.fSection.setLayoutData((Object)data);
        this.fSection.setText(PDEUIMessages.SplashProgressSection_progressName);
        this.fSection.setDescription(PDEUIMessages.SplashProgressSection_progressSectionDesc);
    }

    private void createProgressBarConfig(Composite parent) {
        this.fAddBarButton = this.createButton(parent, this.fToolkit, PDEUIMessages.SplashSection_progressBar);
        this.fAddBarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = SplashConfigurationSection.this.fAddBarButton.getSelection();
                SplashConfigurationSection.this.getSplashInfo().addProgressBar(enable, false);
                SplashConfigurationSection.this.updateFieldEnablement();
            }
        });
        GridData data = new GridData(768);
        data.verticalIndent = 5;
        data.horizontalSpan = 10;
        this.fAddBarButton.setLayoutData((Object)data);
        this.fAddBarButton.setEnabled(this.isEditable());
        Color foreground = this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fBarControls[0] = this.createLabel(parent, this.fToolkit, foreground, PDEUIMessages.SplashSection_progressX);
        this.fBarSpinners[0] = this.createSpinner(parent, this.fToolkit);
        this.fBarControls[1] = this.fBarSpinners[0];
        this.fBarControls[2] = this.createLabel(parent, this.fToolkit, foreground, PDEUIMessages.SplashSection_progressY);
        this.fBarSpinners[1] = this.createSpinner(parent, this.fToolkit);
        this.fBarControls[3] = this.fBarSpinners[1];
        this.fBarControls[4] = this.createLabel(parent, this.fToolkit, foreground, PDEUIMessages.SplashSection_progressWidth);
        this.fBarSpinners[2] = this.createSpinner(parent, this.fToolkit);
        this.fBarControls[5] = this.fBarSpinners[2];
        this.fBarControls[6] = this.createLabel(parent, this.fToolkit, foreground, PDEUIMessages.SplashSection_progressHeight);
        this.fBarSpinners[3] = this.createSpinner(parent, this.fToolkit);
        this.fBarControls[7] = this.fBarSpinners[3];
        this.addOffsetTooltips(this.fBarControls);
        int i = 0;
        while (i < this.fBarSpinners.length) {
            this.fBarSpinners[i].setEnabled(this.isEditable());
            this.fBarSpinners[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SplashConfigurationSection.this.applySpinners(true);
                }
            });
            ++i;
        }
        Composite filler = this.fToolkit.createComposite(parent);
        filler.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        filler.setLayoutData((Object)gd);
    }

    private void createProgressMessageConfig(Composite parent) {
        this.fAddMessageButton = this.createButton(parent, this.fToolkit, PDEUIMessages.SplashSection_progressMessage);
        this.fAddMessageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = SplashConfigurationSection.this.fAddMessageButton.getSelection();
                SplashConfigurationSection.this.getSplashInfo().addProgressMessage(enable, false);
                SplashConfigurationSection.this.updateFieldEnablement();
            }
        });
        this.fAddMessageButton.setEnabled(false);
        Color foreground = this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fMessageControls[0] = this.createLabel(parent, this.fToolkit, foreground, PDEUIMessages.SplashSection_messageX);
        this.fMessageSpinners[0] = this.createSpinner(parent, this.fToolkit);
        this.fMessageControls[1] = this.fMessageSpinners[0];
        this.fMessageControls[2] = this.createLabel(parent, this.fToolkit, foreground, PDEUIMessages.SplashSection_messageY);
        this.fMessageSpinners[1] = this.createSpinner(parent, this.fToolkit);
        this.fMessageControls[3] = this.fMessageSpinners[1];
        this.fMessageControls[4] = this.createLabel(parent, this.fToolkit, foreground, PDEUIMessages.SplashSection_messageWidth);
        this.fMessageSpinners[2] = this.createSpinner(parent, this.fToolkit);
        this.fMessageControls[5] = this.fMessageSpinners[2];
        this.fMessageControls[6] = this.createLabel(parent, this.fToolkit, foreground, PDEUIMessages.SplashSection_messageHeight);
        this.fMessageSpinners[3] = this.createSpinner(parent, this.fToolkit);
        this.fMessageControls[7] = this.fMessageSpinners[3];
        this.fMessageControls[8] = this.createLabel(parent, this.fToolkit, foreground, PDEUIMessages.SplashSection_messageColor);
        this.fColorSelector = new ColorSelector(parent);
        this.fColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!event.getNewValue().equals(event.getOldValue())) {
                    SplashConfigurationSection.this.applyColor();
                }
            }
        });
        this.fToolkit.adapt((Control)this.fColorSelector.getButton(), true, true);
        this.fMessageControls[9] = this.fColorSelector.getButton();
        this.addOffsetTooltips(this.fMessageControls);
        int i = 0;
        while (i < this.fMessageSpinners.length) {
            this.fMessageSpinners[i].setEnabled(this.isEditable());
            this.fMessageSpinners[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SplashConfigurationSection.this.applySpinners(false);
                }
            });
            ++i;
        }
    }

    private void applyColor() {
        if (this.fBlockNotification) {
            return;
        }
        RGB rgb = this.fColorSelector.getColorValue();
        this.getSplashInfo().setForegroundColor(this.rgbToHEX(rgb), false);
    }

    private void applySpinners(boolean bar) {
        if (this.fBlockNotification) {
            return;
        }
        Spinner[] spinners = bar ? this.fBarSpinners : this.fMessageSpinners;
        int[] geo = new int[]{spinners[0].getSelection(), spinners[1].getSelection(), spinners[2].getSelection(), spinners[3].getSelection()};
        if (bar) {
            this.getSplashInfo().setProgressGeometry(geo, false);
        } else {
            this.getSplashInfo().setMessageGeometry(geo, false);
        }
    }

    private Label createLabel(Composite parent, FormToolkit toolkit, Color color, String labelName) {
        Label label = toolkit.createLabel(parent, labelName);
        label.setForeground(color);
        GridData gd = new GridData();
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Button createButton(Composite parent, FormToolkit toolkit, String label) {
        Button button = toolkit.createButton(parent, label, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 10;
        button.setLayoutData((Object)gd);
        return button;
    }

    private Spinner createSpinner(Composite parent, FormToolkit toolkit) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMinimum(0);
        spinner.setMaximum(9999);
        toolkit.adapt((Control)spinner, false, false);
        return spinner;
    }

    private void resetProgressBarGeometry() {
        this.fBarSpinners[0].setSelection(5);
        this.fBarSpinners[1].setSelection(275);
        this.fBarSpinners[2].setSelection(445);
        this.fBarSpinners[3].setSelection(15);
    }

    private void resetProgressMessageGeometry() {
        this.fMessageSpinners[0].setSelection(7);
        this.fMessageSpinners[1].setSelection(252);
        this.fMessageSpinners[2].setSelection(445);
        this.fMessageSpinners[3].setSelection(20);
    }

    public void refresh() {
        ISplashInfo info = this.getSplashInfo();
        this.fBlockNotification = true;
        this.fColorSelector.setColorValue(this.hexToRGB(info.getForegroundColor()));
        int[] pgeo = info.getProgressGeometry();
        boolean addProgress = pgeo != null;
        info.addProgressBar(addProgress, this.fBlockNotification);
        if (addProgress) {
            int i = 0;
            while (i < pgeo.length) {
                this.fBarSpinners[i].setSelection(pgeo[i]);
                ++i;
            }
        } else {
            this.resetProgressBarGeometry();
        }
        this.fAddBarButton.setSelection(addProgress);
        int[] mgeo = info.getMessageGeometry();
        boolean addMessage = mgeo != null;
        info.addProgressMessage(addMessage, this.fBlockNotification);
        if (addMessage) {
            int i = 0;
            while (i < mgeo.length) {
                this.fMessageSpinners[i].setSelection(mgeo[i]);
                ++i;
            }
        } else {
            this.resetProgressMessageGeometry();
        }
        this.fColorSelector.setColorValue(addMessage ? this.hexToRGB(info.getForegroundColor()) : new RGB(0, 0, 0));
        this.fAddMessageButton.setSelection(addMessage);
        this.updateUIFieldTemplateCombo();
        this.fBlockNotification = false;
        super.refresh();
        this.updateFieldEnablement();
    }

    private void updateUIFieldTemplateCombo() {
        this.updateFieldEnablement();
        ISplashInfo info = this.getSplashInfo();
        if (!info.isDefinedSplashHandlerType()) {
            this.fFieldTemplateCombo.setText(PDEUIMessages.SplashConfigurationSection_none);
            return;
        }
        String splashHandlerType = info.getFieldSplashHandlerType();
        int i = 0;
        while (i < ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES.length) {
            String key = ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES[i][0];
            if (splashHandlerType.equals(key)) {
                String displayName = ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES[i][1];
                this.fFieldTemplateCombo.setText(displayName);
            }
            ++i;
        }
    }

    private ISplashInfo getSplashInfo() {
        ISplashInfo info = this.getProduct().getSplashInfo();
        if (info == null) {
            info = this.getModel().getFactory().createSplashInfo();
            this.getProduct().setSplashInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    private String rgbToHEX(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return String.valueOf(this.rgbToHex(rgb.red)) + this.rgbToHex(rgb.green) + this.rgbToHex(rgb.blue);
    }

    private String rgbToHex(int value) {
        value = Math.max(0, value);
        String hex = Integer.toHexString(value = Math.min(value, 255)).toUpperCase();
        if (hex.length() == 1) {
            hex = String.valueOf('0') + hex;
        }
        return hex;
    }

    private RGB hexToRGB(String hexValue) {
        if (hexValue == null || hexValue.length() < 6) {
            return new RGB(0, 0, 0);
        }
        return new RGB(Integer.parseInt(hexValue.substring(0, 2), 16), Integer.parseInt(hexValue.substring(2, 4), 16), Integer.parseInt(hexValue.substring(4, 6), 16));
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        } else if (e.getChangeType() == 3) {
            this.handleModelEventChange(e);
        }
    }

    private void handleModelEventChange(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        IProductObject object = (IProductObject)objects[0];
        if (object != null && object instanceof IProduct && event.getChangedProperty() == "id") {
            this.updateFieldEnablement();
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void updateFieldEnablement() {
        this.updateFieldProgressEnablement();
        this.updateFieldTemplateEnablement();
    }

    private void updateFieldProgressEnablement() {
        ISplashInfo info = this.getSplashInfo();
        if (!PDETextHelper.isDefined((String)this.getProduct().getProductId()) || !info.isDefinedGeometry() && info.isDefinedSplashHandlerType()) {
            this.fAddBarButton.setEnabled(false);
            this.fAddMessageButton.setEnabled(false);
            this.updateFieldProgressBarEnablement(false);
            this.updateFieldProgressMessageEnablement(false);
        } else {
            this.fAddBarButton.setEnabled(this.isEditable());
            this.fAddMessageButton.setEnabled(this.isEditable());
            this.updateFieldProgressBarEnablement(this.isEditable());
            this.updateFieldProgressMessageEnablement(this.isEditable());
        }
    }

    private void updateFieldProgressBarEnablement(boolean buttonEnabled) {
        boolean enable = this.fAddBarButton.getSelection() && buttonEnabled;
        int i = 0;
        while (i < this.fBarControls.length) {
            this.fBarControls[i].setEnabled(enable);
            ++i;
        }
    }

    private void updateFieldProgressMessageEnablement(boolean buttonEnabled) {
        boolean enable = this.fAddMessageButton.getSelection() && buttonEnabled;
        int i = 0;
        while (i < this.fMessageControls.length) {
            this.fMessageControls[i].setEnabled(enable);
            ++i;
        }
    }

    private void updateFieldTemplateEnablement() {
        ISplashInfo info = this.getSplashInfo();
        if (!PDETextHelper.isDefined((String)this.getProduct().getProductId()) || info.isDefinedGeometry() && !info.isDefinedSplashHandlerType()) {
            this.fFieldTemplateCombo.setEnabled(false);
        } else {
            this.fFieldTemplateCombo.setEnabled(true);
        }
    }

    private void addOffsetTooltips(Control[] controls) {
        int limit = 4;
        if (controls.length < limit) {
            return;
        }
        int i = 0;
        while (i < limit) {
            controls[i].setToolTipText(PDEUIMessages.SplashConfigurationSection_msgTooltipOffsetRelative);
            ++i;
        }
    }
}

