/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.ActionProvider;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.EditorProvider;
import org.eclipse.ui.internal.quickaccess.PerspectiveProvider;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.internal.quickaccess.PropertiesProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessContents;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.internal.quickaccess.WizardProvider;
import org.eclipse.ui.swt.IFocusService;

public class SearchField {
    private static final String TEXT_ARRAY = "textArray";
    private static final String TEXT_ENTRIES = "textEntries";
    private static final String ORDERED_PROVIDERS = "orderedProviders";
    private static final String ORDERED_ELEMENTS = "orderedElements";
    private static final int MAXIMUM_NUMBER_OF_ELEMENTS = 60;
    private static final int MAXIMUM_NUMBER_OF_TEXT_ENTRIES_PER_ELEMENT = 3;
    Shell shell;
    private Text text;
    private QuickAccessContents quickAccessContents;
    private MWindow window;
    private Map<String, QuickAccessProvider> providerMap = new HashMap<String, QuickAccessProvider>();
    private Map<String, QuickAccessElement> elementMap = new HashMap<String, QuickAccessElement>();
    private Map<QuickAccessElement, ArrayList<String>> textMap = new HashMap<QuickAccessElement, ArrayList<String>>();
    private LinkedList<QuickAccessElement> previousPicksList = new LinkedList();

    @PostConstruct
    void createWidget(Composite parent, MApplication application, MWindow window) {
        this.window = window;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.text = new Text(comp, 640);
        GridDataFactory.fillDefaults().hint(130, -1).applyTo((Control)this.text);
        this.text.setMessage(QuickAccessMessages.QuickAccess_EnterSearch);
        this.hookUpSelectAll();
        final CommandProvider commandProvider = new CommandProvider();
        QuickAccessProvider[] providers = new QuickAccessProvider[]{new PreviousPicksProvider(), new EditorProvider(), new ViewProvider(application, window), new PerspectiveProvider(), commandProvider, new ActionProvider(), new WizardProvider(), new PreferenceProvider(), new PropertiesProvider()};
        int i = 0;
        while (i < providers.length) {
            this.providerMap.put(providers[i].getId(), providers[i]);
            ++i;
        }
        this.restoreDialog();
        this.quickAccessContents = new QuickAccessContents(providers){

            void updateFeedback(boolean filterTextEmpty, boolean showAllMatches) {
            }

            void doClose() {
            }

            QuickAccessElement getPerfectMatch(String filter) {
                return (QuickAccessElement)SearchField.this.elementMap.get(filter);
            }

            void handleElementSelected(String string, Object selectedElement) {
                if (selectedElement instanceof QuickAccessElement) {
                    QuickAccessElement element = (QuickAccessElement)selectedElement;
                    SearchField.this.addPreviousPick(string, element);
                    SearchField.this.text.setText("");
                    element.execute();
                }
            }
        };
        this.quickAccessContents.hookFilterText(this.text);
        this.shell = new Shell(parent.getShell(), 16400);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SearchField.this.text.setText("");
                e.doit = false;
            }
        });
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.shell);
        final Table table = this.quickAccessContents.createTable((Composite)this.shell, Window.getDefaultOrientation());
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SearchField.this.checkFocusLost(table, SearchField.this.text);
            }

            public void focusGained(FocusEvent e) {
                IHandlerService hs = (IHandlerService)SearchField.this.window.getContext().get(IHandlerService.class);
                if (commandProvider.getContextSnapshot() == null) {
                    commandProvider.setSnapshot(hs.createContextSnapshot(true));
                }
            }
        });
        this.shell.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SearchField.this.checkFocusLost(table, SearchField.this.text);
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean nowVisible;
                boolean wasVisible = SearchField.this.shell.getVisible();
                boolean bl = nowVisible = SearchField.this.text.getText().length() > 0;
                if (!wasVisible && nowVisible) {
                    SearchField.this.layoutShell();
                }
                SearchField.this.shell.setVisible(nowVisible);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    SearchField.this.text.setText("");
                }
            }
        });
    }

    private void hookUpSelectAll() {
        IEclipseContext windowContext = this.window.getContext();
        IFocusService focus = (IFocusService)windowContext.get(IFocusService.class);
        focus.addFocusTracker((Control)this.text, SearchField.class.getName());
        Expression focusExpr = new Expression(){

            public void collectExpressionInfo(ExpressionInfo info) {
                info.addVariableNameAccess("activeFocusControlId");
            }

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                return EvaluationResult.valueOf((boolean)SearchField.class.getName().equals(context.getVariable("activeFocusControlId")));
            }
        };
        IHandlerService whService = (IHandlerService)windowContext.get(IHandlerService.class);
        whService.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                SearchField.this.text.selectAll();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                SearchField.this.text.cut();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                SearchField.this.text.copy();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                SearchField.this.text.paste();
                return null;
            }
        }, focusExpr);
    }

    private static Monitor getClosestMonitor(Display toSearch, Point toFind) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = toSearch.getMonitors();
        Monitor result = monitors[0];
        int idx = 0;
        while (idx < monitors.length) {
            Monitor current = monitors[idx];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(toFind)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++idx;
        }
        return result;
    }

    private Rectangle getConstrainedShellBounds(Display display, Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Monitor mon = SearchField.getClosestMonitor(display, Geometry.centerPoint((Rectangle)result));
        Rectangle bounds = mon.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }

    void layoutShell() {
        Display display = this.text.getDisplay();
        Composite parent = this.text.getParent();
        Rectangle tempBounds = parent.getBounds();
        Rectangle compBounds = display.map((Control)parent, null, tempBounds);
        int width = Math.max(350, compBounds.width);
        int height = 250;
        this.shell.setBounds(this.getConstrainedShellBounds(display, new Rectangle(compBounds.x, compBounds.y + compBounds.height, width, height)));
        this.shell.layout();
    }

    public void activate() {
        if (!this.shell.isVisible()) {
            this.layoutShell();
            this.shell.setVisible(true);
            this.quickAccessContents.refresh(this.text.getText().toLowerCase());
        }
    }

    protected void checkFocusLost(final Table table, final Text text) {
        table.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!(table.isDisposed() || text.isDisposed() || table.isFocusControl() || text.isFocusControl())) {
                    text.setText("");
                    SearchField.this.quickAccessContents.resetProviders();
                }
            }
        });
    }

    private void restoreDialog() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            String[] orderedElements = dialogSettings.getArray(ORDERED_ELEMENTS);
            String[] orderedProviders = dialogSettings.getArray(ORDERED_PROVIDERS);
            String[] textEntries = dialogSettings.getArray(TEXT_ENTRIES);
            String[] textArray = dialogSettings.getArray(TEXT_ARRAY);
            if (orderedElements != null && orderedProviders != null && textEntries != null && textArray != null) {
                int arrayIndex = 0;
                int i = 0;
                while (i < orderedElements.length) {
                    QuickAccessElement quickAccessElement;
                    QuickAccessProvider quickAccessProvider = this.providerMap.get(orderedProviders[i]);
                    int numTexts = Integer.parseInt(textEntries[i]);
                    if (quickAccessProvider != null && (quickAccessElement = quickAccessProvider.getElementForId(orderedElements[i])) != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int j = arrayIndex;
                        while (j < arrayIndex + numTexts) {
                            String text = textArray[j];
                            if (text.length() > 0) {
                                arrayList.add(text);
                                this.elementMap.put(text, quickAccessElement);
                            }
                            ++j;
                        }
                        this.textMap.put(quickAccessElement, arrayList);
                        this.previousPicksList.add(quickAccessElement);
                    }
                    arrayIndex += numTexts;
                    ++i;
                }
            }
        }
    }

    @PreDestroy
    void dispose() {
        this.storeDialog();
    }

    private void storeDialog() {
        String[] orderedElements = new String[this.previousPicksList.size()];
        String[] orderedProviders = new String[this.previousPicksList.size()];
        String[] textEntries = new String[this.previousPicksList.size()];
        ArrayList<String> arrayList = new ArrayList<String>();
        int i = 0;
        while (i < orderedElements.length) {
            QuickAccessElement quickAccessElement = this.previousPicksList.get(i);
            ArrayList<String> elementText = this.textMap.get(quickAccessElement);
            Assert.isNotNull(elementText);
            orderedElements[i] = quickAccessElement.getId();
            orderedProviders[i] = quickAccessElement.getProvider().getId();
            arrayList.addAll(elementText);
            textEntries[i] = String.valueOf(elementText.size());
            ++i;
        }
        String[] textArray = arrayList.toArray(new String[arrayList.size()]);
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(ORDERED_ELEMENTS, orderedElements);
        dialogSettings.put(ORDERED_PROVIDERS, orderedProviders);
        dialogSettings.put(TEXT_ENTRIES, textEntries);
        dialogSettings.put(TEXT_ARRAY, textArray);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(this.getId());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(this.getId());
        }
        return result;
    }

    private String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    private void addPreviousPick(String text, QuickAccessElement element) {
        this.previousPicksList.remove(element);
        if (this.previousPicksList.size() == 60) {
            QuickAccessElement removedElement = this.previousPicksList.removeLast();
            ArrayList<String> removedList = this.textMap.remove(removedElement);
            int i = 0;
            while (i < removedList.size()) {
                this.elementMap.remove(removedList.get(i));
                ++i;
            }
        }
        this.previousPicksList.addFirst(element);
        ArrayList<String> textList = this.textMap.get(element);
        if (textList == null) {
            textList = new ArrayList();
            this.textMap.put(element, textList);
        }
        textList.remove(text);
        if (textList.size() == 3) {
            String removedText = textList.remove(0);
            this.elementMap.remove(removedText);
        }
        if (text.length() > 0) {
            textList.add(text);
            QuickAccessElement replacedElement = this.elementMap.put(text, element);
            if (replacedElement != null && !replacedElement.equals(element) && (textList = this.textMap.get(replacedElement)) != null) {
                textList.remove(text);
                if (textList.isEmpty()) {
                    this.textMap.remove(replacedElement);
                    this.previousPicksList.remove(replacedElement);
                }
            }
        }
    }

    private class PreviousPicksProvider
    extends QuickAccessProvider {
        private PreviousPicksProvider() {
        }

        public QuickAccessElement getElementForId(String id) {
            return null;
        }

        public QuickAccessElement[] getElements() {
            return SearchField.this.previousPicksList.toArray(new QuickAccessElement[SearchField.this.previousPicksList.size()]);
        }

        public QuickAccessElement[] getElementsSorted() {
            return this.getElements();
        }

        public String getId() {
            return "org.eclipse.ui.previousPicks";
        }

        public ImageDescriptor getImageDescriptor() {
            return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
        }

        public String getName() {
            return QuickAccessMessages.QuickAccess_Previous;
        }

        protected void doReset() {
        }

        public boolean isAlwaysPresent() {
            return true;
        }
    }
}

