/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import com.sun.mirror.util.SourcePosition;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationMirrorImpl;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationValueImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;

public class SourcePositionImpl
implements SourcePosition {
    private final int _startingOffset;
    private final int _length;
    private final int _line;
    private final int _column;
    private final EclipseMirrorObject _decl;

    public SourcePositionImpl(int startingOffset, int length, int line, int column, EclipseDeclarationImpl decl) {
        this._startingOffset = startingOffset;
        this._length = length;
        this._line = line < 1 ? 1 : line;
        this._column = column < 0 ? 0 : column;
        this._decl = decl;
        assert (decl != null) : "missing declaration [decl] == null.";
    }

    public SourcePositionImpl(int startingOffset, int length, int line, int column, AnnotationValueImpl decl) {
        this._startingOffset = startingOffset;
        this._length = length;
        this._line = line < 1 ? 1 : line;
        this._column = column < 0 ? 0 : column;
        this._decl = decl;
        assert (decl != null) : "missing declaration [decl] == null.";
    }

    public SourcePositionImpl(int startingOffset, int length, int line, int column, AnnotationMirrorImpl decl) {
        this._startingOffset = startingOffset;
        this._length = length;
        this._line = line < 1 ? 1 : line;
        this._column = column < 0 ? 0 : column;
        this._decl = decl;
        assert (decl != null) : "missing declaration [decl] == null.";
    }

    public int line() {
        return this._line;
    }

    public int column() {
        return this._column;
    }

    public File file() {
        IFile resource = this.getResource();
        if (resource == null) {
            return null;
        }
        IPath absPath = resource.getRawLocation();
        if (absPath == null) {
            return null;
        }
        return new File(absPath.toOSString());
    }

    public int getStartingOffset() {
        return this._startingOffset;
    }

    public int getEndingOffset() {
        return this._startingOffset + this._length;
    }

    public int getLength() {
        return this._length;
    }

    public IFile getResource() {
        if (this._decl instanceof EclipseDeclarationImpl) {
            return ((EclipseDeclarationImpl)this._decl).getResource();
        }
        if (this._decl instanceof AnnotationMirrorImpl) {
            return ((AnnotationMirrorImpl)this._decl).getResource();
        }
        if (this._decl instanceof AnnotationValueImpl) {
            return ((AnnotationValueImpl)this._decl).getResource();
        }
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("offset = ");
        buffer.append(this._startingOffset);
        buffer.append(" line = ");
        buffer.append(this._line);
        buffer.append(" column = ");
        buffer.append(this._column);
        buffer.append(" length = ");
        buffer.append(this._length);
        return buffer.toString();
    }
}

