/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.internal.AbstractTableInformationControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPartList
extends AbstractTableInformationControl {
    private Map<String, Image> images = new HashMap<String, Image>();
    private ISWTResourceUtilities utils;
    private MPartStack input;
    private EPartService partService;

    public BasicPartList(Shell parent, int shellStyle, int treeStyler, EPartService partService, MPartStack input, ISWTResourceUtilities utils) {
        super(parent, shellStyle, treeStyler);
        this.partService = partService;
        this.input = input;
        this.utils = utils;
    }

    private Image getLabelImage(String iconURI) {
        Image image = this.images.get(iconURI);
        if (image == null) {
            ImageDescriptor descriptor = (ImageDescriptor)this.utils.imageDescriptorFromURI(URI.createURI((String)iconURI));
            image = descriptor.createImage();
            this.images.put(iconURI, image);
        }
        return image;
    }

    @Override
    protected TableViewer createTableViewer(Composite parent, int style) {
        Table table = new Table(parent, 4 | style & 0xFFFFFFFD);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.addFilter((ViewerFilter)new AbstractTableInformationControl.NamePatternFilter());
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setLabelProvider((IBaseLabelProvider)new BasicStackListLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        table.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                for (Image image : BasicPartList.this.images.values()) {
                    image.dispose();
                }
            }
        });
        return tableViewer;
    }

    private List<Object> getInput() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (MUIElement element : this.input.getChildren()) {
            if (element instanceof MPlaceholder) {
                element = ((MPlaceholder)element).getRef();
            }
            if (!element.isToBeRendered() || !element.isVisible() || !(element instanceof MPart)) continue;
            list.add(element);
        }
        return list;
    }

    public void setInput() {
        this.getTableViewer().setInput(this.getInput());
        this.selectFirstMatch();
    }

    @Override
    protected void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        this.dispose();
        if (selectedElement instanceof MPart) {
            this.partService.activate((MPart)selectedElement);
        }
    }

    @Override
    protected boolean deleteSelectedElements() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            this.partService.hidePart((MPart)selectedElement);
            if (this.getInput().isEmpty()) {
                this.getShell().dispose();
                return true;
            }
        }
        return false;
    }

    private class BasicStackListLabelProvider
    extends ColumnLabelProvider {
        private BasicStackListLabelProvider() {
        }

        public String getText(Object element) {
            return ((MUILabel)element).getLabel();
        }

        public Image getImage(Object element) {
            return BasicPartList.this.getLabelImage(((MUILabel)element).getIconURI());
        }

        public String getToolTipText(Object element) {
            return ((MUILabel)element).getTooltip();
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }
    }
}

