/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.EscapeBackslashCompletionProposal;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEscapes;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;

public class PropertiesCorrectionProcessor
implements IQuickAssistProcessor {
    private String fErrorMessage;
    private SpellingCorrectionProcessor fSpellingCorrectionProcessor = new SpellingCorrectionProcessor();
    private ICompletionProposal[] fPreComputedProposals;

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        TextInvocationContext context = new TextInvocationContext(viewer, quickAssistContext.getOffset(), length);
        this.fErrorMessage = null;
        ICompletionProposal[] res = null;
        if (this.fPreComputedProposals != null) {
            res = this.fPreComputedProposals;
        } else {
            try {
                ICompletionProposal[] assists;
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                ICompletionProposal[] spellingProposals = this.fSpellingCorrectionProcessor.computeQuickAssistProposals(quickAssistContext);
                if (spellingProposals.length > 1) {
                    int i = 0;
                    while (i < spellingProposals.length) {
                        proposals.add(spellingProposals[i]);
                        ++i;
                    }
                }
                if ((assists = PropertiesCorrectionProcessor.collectAssists((IQuickAssistInvocationContext)context)) != null) {
                    int i = 0;
                    while (i < assists.length) {
                        proposals.add(assists[i]);
                        ++i;
                    }
                }
                res = proposals.toArray(new ICompletionProposal[proposals.size()]);
            }
            catch (BadLocationException e) {
                this.fErrorMessage = CorrectionMessages.JavaCorrectionProcessor_error_quickassist_message;
                JavaPlugin.log(e);
            }
            catch (BadPartitioningException e) {
                this.fErrorMessage = CorrectionMessages.JavaCorrectionProcessor_error_quickassist_message;
                JavaPlugin.log(e);
            }
        }
        if (res == null || res.length == 0) {
            return new ICompletionProposal[]{new ChangeCorrectionProposal(CorrectionMessages.NoCorrectionProposal_description, (Change)new NullChange(""), 0, null)};
        }
        if (res.length > 1) {
            Arrays.sort(res, new CompletionProposalComparator());
        }
        this.fPreComputedProposals = null;
        return res;
    }

    private static ICompletionProposal[] collectAssists(IQuickAssistInvocationContext invocationContext) throws BadLocationException, BadPartitioningException {
        String text;
        int proposalLength;
        int proposalOffset;
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selectedRange = sourceViewer.getSelectedRange();
        int selectionOffset = selectedRange.x;
        int selectionLength = selectedRange.y;
        if (selectionLength == 0) {
            char ch;
            if (selectionOffset != document.getLength() && ((ch = document.getChar(selectionOffset)) == '=' || ch == ':')) {
                return null;
            }
            ITypedRegion partition = null;
            if (document instanceof IDocumentExtension3) {
                partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", invocationContext.getOffset(), false);
            }
            if (partition == null) {
                return null;
            }
            String type = partition.getType();
            if (!type.equals("__pf_roperty_value") && !type.equals("__dftl_partition_content_type")) {
                return null;
            }
            proposalOffset = partition.getOffset();
            proposalLength = partition.getLength();
            text = document.get(proposalOffset, proposalLength);
            if (type.equals("__pf_roperty_value")) {
                text = text.substring(1);
                ++proposalOffset;
                --proposalLength;
            }
        } else {
            proposalOffset = selectionOffset;
            proposalLength = selectionLength;
            text = document.get(proposalOffset, proposalLength);
        }
        if (PropertiesFileEscapes.containsUnescapedBackslash(text)) {
            return new ICompletionProposal[]{new EscapeBackslashCompletionProposal(PropertiesFileEscapes.escape(text, false, true, false), proposalOffset, proposalLength, true)};
        }
        if (PropertiesFileEscapes.containsEscapedBackslashes(text)) {
            return new ICompletionProposal[]{new EscapeBackslashCompletionProposal(PropertiesFileEscapes.unescapeBackslashes(text), proposalOffset, proposalLength, false)};
        }
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean canFix(Annotation annotation) {
        return this.fSpellingCorrectionProcessor.canFix(annotation);
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        try {
            return PropertiesCorrectionProcessor.collectAssists(invocationContext) != null;
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        catch (BadPartitioningException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    public void setProposals(ICompletionProposal[] preComputedProposals) {
        this.fPreComputedProposals = preComputedProposals;
    }
}

