/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;

public class LaunchConfigurationListener
implements ILaunchConfigurationListener {
    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        final File configDir = LaunchConfigurationHelper.getConfigurationLocation(configuration);
        if (configDir.exists()) {
            ILaunchConfiguration destination = DebugPlugin.getDefault().getLaunchManager().getMovedTo(configuration);
            boolean delete = true;
            if (destination != null) {
                boolean bl = delete = !configDir.renameTo(LaunchConfigurationHelper.getConfigurationLocation(destination));
            }
            if (delete) {
                Job job = new Job("Clean Configuration Data"){

                    protected IStatus run(IProgressMonitor monitor) {
                        CoreUtility.deleteContent((File)configDir);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }
}

