/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.debug.ui;

import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextMessages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class LeaksDialog
extends ElementTreeSelectionDialog {
    public LeaksDialog(Shell parent) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new ListenerContentProvider());
        this.setComparator(new ViewerComparator());
        this.setTitle(ContextMessages.diffDialogTitle);
        this.setMessage(ContextMessages.diffDialogMessage);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private static class ListenerContentProvider
    implements ITreeContentProvider {
        private Map<EclipseContext, Set<Computation>> snapshotDiff;

        public void dispose() {
            if (this.snapshotDiff == null) {
                return;
            }
            this.snapshotDiff.clear();
            this.snapshotDiff = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.snapshotDiff = (Map)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return ((Map)inputElement).keySet().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (this.snapshotDiff == null) {
                return null;
            }
            if (parentElement instanceof EclipseContext) {
                return this.snapshotDiff.get(parentElement).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (this.snapshotDiff == null) {
                return null;
            }
            if (element instanceof Computation) {
                for (EclipseContext context : this.snapshotDiff.keySet()) {
                    Set<Computation> computations = this.snapshotDiff.get(context);
                    if (!computations.contains(element)) continue;
                    return context;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (this.snapshotDiff == null) {
                return false;
            }
            if (element instanceof EclipseContext) {
                if (!this.snapshotDiff.containsKey(element)) {
                    return false;
                }
                return !this.snapshotDiff.get(element).isEmpty();
            }
            return false;
        }
    }
}

