/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.DirectContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarContributionRecord;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolControlContribution;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarManagerRenderer
extends SWTPartRenderer {
    private static final String TOOL_BAR_MANAGER_RENDERER_DRAG_HANDLE = "ToolBarManagerRenderer.dragHandle";
    private Map<MToolBar, ToolBarManager> modelToManager = new HashMap<MToolBar, ToolBarManager>();
    private Map<ToolBarManager, MToolBar> managerToModel = new HashMap<ToolBarManager, MToolBar>();
    private Map<MToolBarElement, IContributionItem> modelToContribution = new HashMap<MToolBarElement, IContributionItem>();
    private Map<IContributionItem, MToolBarElement> contributionToModel = new HashMap<IContributionItem, MToolBarElement>();
    private Map<MToolBarElement, ToolBarContributionRecord> modelContributionToRecord = new HashMap<MToolBarElement, ToolBarContributionRecord>();
    private Map<MToolBarElement, ArrayList<ToolBarContributionRecord>> sharedElementToRecord = new HashMap<MToolBarElement, ArrayList<ToolBarContributionRecord>>();
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
                return;
            }
            MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
            IContributionItem ici = ToolBarManagerRenderer.this.getContribution(itemModel);
            if (ici == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName)) {
                ici.update();
            } else if ("iconURI".equals(attName)) {
                ici.update();
            } else if ("tooltip".equals(attName)) {
                ici.update();
            }
        }
    };
    private EventHandler toBeRenderedUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
                return;
            }
            MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
            String attName = (String)event.getProperty("AttName");
            if ("toBeRendered".equals(attName)) {
                MElementContainer obj = itemModel.getParent();
                if (!(obj instanceof MToolBar)) {
                    return;
                }
                ToolBarManager parent = ToolBarManagerRenderer.this.getManager((MToolBar)obj);
                if (itemModel.isToBeRendered()) {
                    if (parent != null) {
                        ToolBarManagerRenderer.this.modelProcessSwitch(parent, itemModel);
                        parent.update(true);
                        ToolBar tb = parent.getControl();
                        if (tb != null && !tb.isDisposed()) {
                            tb.getShell().layout(new Control[]{tb}, 4);
                        }
                    }
                } else {
                    IContributionItem ici = (IContributionItem)ToolBarManagerRenderer.this.modelToContribution.remove(itemModel);
                    if (ici != null && parent != null) {
                        parent.remove(ici);
                    }
                    if (ici != null) {
                        ici.dispose();
                    }
                }
            } else if ("visible".equals(attName)) {
                IContributionItem ici = ToolBarManagerRenderer.this.getContribution(itemModel);
                if (ici == null) {
                    return;
                }
                ici.setVisible(itemModel.isVisible());
                ToolBarManager parent = (ToolBarManager)((ContributionItem)ici).getParent();
                if (parent != null) {
                    parent.markDirty();
                    parent.update(true);
                    ToolBar tb = parent.getControl();
                    if (tb != null && !tb.isDisposed()) {
                        tb.getShell().layout(new Control[]{tb}, 4);
                    }
                }
            }
        }
    };
    private EventHandler selectionUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
                return;
            }
            MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
            IContributionItem ici = ToolBarManagerRenderer.this.getContribution(itemModel);
            if (ici != null) {
                ici.update();
            }
        }
    };
    private EventHandler enabledUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
                return;
            }
            MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
            IContributionItem ici = ToolBarManagerRenderer.this.getContribution(itemModel);
            if (ici != null) {
                ici.update();
            }
        }
    };
    private EventHandler childAdditionUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolBar)) {
                return;
            }
            MToolBar toolbarModel = (MToolBar)event.getProperty("ChangedElement");
            String eventType = (String)event.getProperty("EventType");
            if ("ADD".equals(eventType)) {
                MToolBar obj = toolbarModel;
                ToolBarManagerRenderer.this.processContents((MElementContainer<MUIElement>)((MElementContainer)obj));
            }
        }
    };

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UILabel"), this.itemUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"selected"), this.selectionUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"enabled"), this.enabledUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement"), this.toBeRenderedUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childAdditionUpdater);
        this.context.set(ToolBarManagerRenderer.class, (Object)this);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.selectionUpdater);
        this.eventBroker.unsubscribe(this.enabledUpdater);
        this.eventBroker.unsubscribe(this.toBeRenderedUpdater);
        this.eventBroker.unsubscribe(this.childAdditionUpdater);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MToolBar) || !(parent instanceof Composite)) {
            return null;
        }
        MToolBar toolbarModel = (MToolBar)element;
        Composite intermediate = this.createIntermediate(toolbarModel, (Composite)parent);
        this.createToolbar((MUIElement)toolbarModel, intermediate);
        this.processContribution(toolbarModel);
        return intermediate;
    }

    private Composite createIntermediate(MToolBar toolbarModel, Composite parent) {
        Composite intermediate = new Composite(parent, 0);
        intermediate.setData("modelElement", (Object)toolbarModel);
        int orientation = this.getOrientation((MUIElement)toolbarModel);
        RowLayout layout = RowLayoutFactory.fillDefaults().wrap(false).spacing(0).type(orientation).create();
        layout.marginLeft = 3;
        layout.center = true;
        intermediate.setLayout((Layout)layout);
        if (this.needsDragHandle(toolbarModel)) {
            ToolBar separatorToolBar = new ToolBar(intermediate, orientation | 0x40 | 0x800000 | 0x20000);
            separatorToolBar.setData((Object)TOOL_BAR_MANAGER_RENDERER_DRAG_HANDLE);
            ToolItem ti = new ToolItem(separatorToolBar, 2);
            ti.setWidth(0);
        }
        return intermediate;
    }

    private boolean needsDragHandle(MToolBar toolbarModel) {
        return toolbarModel != null && ((EObject)toolbarModel).eContainer() instanceof MTrimBar;
    }

    private void processContribution(MToolBar toolbarModel) {
        ArrayList<MToolBarContribution> toContribute = new ArrayList<MToolBarContribution>();
        ContributionsAnalyzer.XXXgatherToolBarContributions((MToolBar)toolbarModel, (List)this.application.getToolBarContributions(), (String)toolbarModel.getElementId(), toContribute);
        this.generateContributions(toolbarModel, toContribute);
    }

    private void generateContributions(MToolBar toolbarModel, ArrayList<MToolBarContribution> toContribute) {
        ToolBarManager manager = this.getManager(toolbarModel);
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MToolBarContribution> curList = new ArrayList<MToolBarContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MToolBarContribution contribution : curList) {
                if (this.processAddition(toolbarModel, manager, contribution)) continue;
                toContribute.add(contribution);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    private boolean processAddition(MToolBar toolbarModel, final ToolBarManager manager, MToolBarContribution contribution) {
        final ToolBarContributionRecord record = new ToolBarContributionRecord(toolbarModel, contribution, this);
        if (!record.mergeIntoModel()) {
            return false;
        }
        if (record.anyVisibleWhen()) {
            final IEclipseContext parentContext = this.modelService.getContainingContext((MUIElement)toolbarModel);
            parentContext.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    record.updateVisibility(parentContext.getActiveLeaf());
                    manager.update(true);
                    return true;
                }
            });
        }
        return true;
    }

    private ToolBar createToolbar(final MUIElement element, Composite parent) {
        ToolBar bar;
        int orientation = this.getOrientation(element);
        ToolBarManager manager = this.getManager((MToolBar)element);
        if (manager == null) {
            manager = new ToolBarManager(orientation | 0x40 | 0x800000 | 0x20000);
            this.linkModelToManager((MToolBar)element, manager);
        }
        if ((bar = manager.createControl(parent)).getParent() != parent) {
            Thread.dumpStack();
        }
        bar.setData((Object)manager);
        bar.setData("modelElement", (Object)element);
        bar.getShell().layout(new Control[]{bar}, 4);
        bar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ToolBarManagerRenderer.this.cleanUp((MToolBar)element);
            }
        });
        return bar;
    }

    protected void cleanUp(MToolBar toolbarModel) {
        Collection<ToolBarContributionRecord> vals = this.modelContributionToRecord.values();
        ToolBarContributionRecord[] toolBarContributionRecordArray = vals.toArray(new ToolBarContributionRecord[vals.size()]);
        int n = toolBarContributionRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolBarContributionRecord record = toolBarContributionRecordArray[n2];
            if (record.toolbarModel == toolbarModel) {
                record.dispose();
                for (MToolBarElement copy : record.generatedElements) {
                    this.cleanUpCopy(record, copy);
                }
                for (MToolBarElement copy : record.sharedElements) {
                    this.cleanUpCopy(record, copy);
                }
                record.generatedElements.clear();
                record.sharedElements.clear();
            }
            ++n2;
        }
    }

    public void cleanUpCopy(ToolBarContributionRecord record, MToolBarElement copy) {
        this.modelContributionToRecord.remove(copy);
        IContributionItem ici = this.getContribution(copy);
        this.clearModelToContribution(copy, ici);
        if (ici != null) {
            record.getManagerForModel().remove(ici);
        }
    }

    int getOrientation(MUIElement element) {
        MTrimBar trimContainer;
        SideValue side;
        MElementContainer theParent = element.getParent();
        if (theParent instanceof MTrimBar && ((side = (trimContainer = (MTrimBar)theParent).getSide()).getValue() == 2 || side.getValue() == 3)) {
            return 512;
        }
        return 256;
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        MElementContainer<MUIElement> obj = container;
        ToolBarManager parentManager = this.getManager((MToolBar)obj);
        if (parentManager == null) {
            return;
        }
        List parts = container.getChildren();
        if (parts != null) {
            MUIElement[] plist = parts.toArray(new MUIElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MUIElement childME = plist[i];
                this.modelProcessSwitch(parentManager, (MToolBarElement)childME);
                ++i;
            }
        }
        parentManager.update(true);
        ToolBar tb = this.getToolbarFrom(container.getWidget());
        if (tb != null) {
            tb.getShell().layout(new Control[]{tb}, 4);
        }
    }

    private ToolBar getToolbarFrom(Object widget) {
        Composite intermediate;
        if (widget instanceof ToolBar) {
            return (ToolBar)widget;
        }
        if (widget instanceof Composite && !(intermediate = (Composite)widget).isDisposed()) {
            Control[] children;
            Control[] controlArray = children = intermediate.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control.getData() instanceof ToolBarManager) {
                    return (ToolBar)control;
                }
                ++n2;
            }
        }
        return null;
    }

    boolean hasOnlySeparators(ToolBar toolbar) {
        ToolItem[] children;
        ToolItem[] toolItemArray = children = toolbar.getItems();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem = toolItemArray[n2];
            if ((toolItem.getStyle() & 2) == 0) {
                return false;
            }
            if (toolItem.getControl() != null && toolItem.getControl().getData("modelElement") instanceof MToolControl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        if (child.getRenderer() != null) {
            ToolBar toolbar;
            Widget widget = (Widget)child.getWidget();
            if (widget != null && !widget.isDisposed()) {
                widget.dispose();
            }
            if ((toolbar = (ToolBar)this.getUIContainer(child)) != null && !toolbar.isDisposed()) {
                toolbar.getShell().layout(new Control[]{toolbar}, 4);
            }
        }
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        this.processContents(parentElement);
        ToolBar toolbar = (ToolBar)this.getUIContainer(element);
        if (toolbar != null && !toolbar.isDisposed()) {
            toolbar.getShell().layout(new Control[]{toolbar}, 4);
        }
    }

    public Object getUIContainer(MUIElement childElement) {
        Composite intermediate = (Composite)super.getUIContainer(childElement);
        if (intermediate == null || intermediate.isDisposed()) {
            return null;
        }
        ToolBar toolbar = this.findToolbar(intermediate);
        if (toolbar == null) {
            toolbar = this.createToolbar((MUIElement)childElement.getParent(), intermediate);
        }
        return toolbar;
    }

    private ToolBar findToolbar(Composite intermediate) {
        Control[] controlArray = intermediate.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getData() instanceof ToolBarManager) {
                return (ToolBar)child;
            }
            ++n2;
        }
        return null;
    }

    private void modelProcessSwitch(ToolBarManager parentManager, MToolBarElement childME) {
        if (childME instanceof MHandledToolItem) {
            MHandledToolItem itemModel = (MHandledToolItem)childME;
            this.processHandledItem(parentManager, itemModel);
        } else if (childME instanceof MDirectToolItem) {
            MDirectToolItem itemModel = (MDirectToolItem)childME;
            this.processDirectItem(parentManager, itemModel);
        } else if (childME instanceof MToolBarSeparator) {
            MToolBarSeparator itemModel = (MToolBarSeparator)childME;
            this.processSeparator(parentManager, itemModel);
        } else if (childME instanceof MToolControl) {
            MToolControl itemModel = (MToolControl)childME;
            this.processToolControl(parentManager, itemModel);
        }
    }

    private void processSeparator(ToolBarManager parentManager, MToolBarSeparator itemModel) {
        IContributionItem ici = this.getContribution((MToolBarElement)itemModel);
        if (ici != null) {
            return;
        }
        Separator marker = null;
        if (itemModel.isVisible()) {
            marker = new Separator();
            marker.setId(itemModel.getElementId());
        } else if (itemModel.getElementId() != null) {
            marker = new GroupMarker(itemModel.getElementId());
        }
        if (marker != null) {
            this.addToManager(parentManager, (MToolBarElement)itemModel, (IContributionItem)marker);
            this.linkModelToContribution((MToolBarElement)itemModel, (IContributionItem)marker);
        }
    }

    private void processToolControl(ToolBarManager parentManager, MToolControl itemModel) {
        IContributionItem ici = this.getContribution((MToolBarElement)itemModel);
        if (ici != null) {
            return;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        ToolControlContribution ci = (ToolControlContribution)((Object)ContextInjectionFactory.make(ToolControlContribution.class, (IEclipseContext)lclContext));
        ci.setModel(itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MToolBarElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MToolBarElement)itemModel, (IContributionItem)ci);
    }

    private void processDirectItem(ToolBarManager parentManager, MDirectToolItem itemModel) {
        IContributionItem ici = this.getContribution((MToolBarElement)itemModel);
        if (ici != null) {
            return;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        DirectContributionItem ci = (DirectContributionItem)((Object)ContextInjectionFactory.make(DirectContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MToolBarElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MToolBarElement)itemModel, (IContributionItem)ci);
    }

    private void processHandledItem(ToolBarManager parentManager, MHandledToolItem itemModel) {
        IContributionItem ici = this.getContribution((MToolBarElement)itemModel);
        if (ici != null) {
            return;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        HandledContributionItem ci = (HandledContributionItem)((Object)ContextInjectionFactory.make(HandledContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MHandledItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MToolBarElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MToolBarElement)itemModel, (IContributionItem)ci);
    }

    private void addToManager(ToolBarManager parentManager, MToolBarElement model, IContributionItem ci) {
        MElementContainer parent = model.getParent();
        if (parent == null) {
            parentManager.add(ci);
        } else {
            int index = parent.getChildren().indexOf(model);
            if (index > parentManager.getSize() || index == -1) {
                parentManager.add(ci);
            } else {
                parentManager.insert(index, ci);
            }
        }
    }

    public ToolBarManager getManager(MToolBar model) {
        return this.modelToManager.get(model);
    }

    public MToolBar getToolBarModel(ToolBarManager manager) {
        return this.managerToModel.get(manager);
    }

    public void linkModelToManager(MToolBar model, ToolBarManager manager) {
        this.modelToManager.put(model, manager);
        this.managerToModel.put(manager, model);
    }

    public void clearModelToManager(MToolBar model, ToolBarManager manager) {
        this.modelToManager.remove(model);
        this.managerToModel.remove(manager);
    }

    public IContributionItem getContribution(MToolBarElement element) {
        return this.modelToContribution.get(element);
    }

    public MToolBarElement getToolElement(IContributionItem item) {
        return this.contributionToModel.get(item);
    }

    public void linkModelToContribution(MToolBarElement model, IContributionItem item) {
        this.modelToContribution.put(model, item);
        this.contributionToModel.put(item, model);
    }

    public void clearModelToContribution(MToolBarElement model, IContributionItem item) {
        this.modelToContribution.remove(model);
        this.contributionToModel.remove(item);
    }

    public ArrayList<ToolBarContributionRecord> getList(MToolBarElement item) {
        ArrayList<ToolBarContributionRecord> tmp = this.sharedElementToRecord.get(item);
        if (tmp == null) {
            tmp = new ArrayList();
            this.sharedElementToRecord.put(item, tmp);
        }
        return tmp;
    }

    public void linkElementToContributionRecord(MToolBarElement element, ToolBarContributionRecord record) {
        this.modelContributionToRecord.put(element, record);
    }

    public ToolBarContributionRecord getContributionRecord(MToolBarElement element) {
        return this.modelContributionToRecord.get(element);
    }
}

