/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.mappings.AbstractCommitAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class CommitAction
extends AbstractCommitAction
implements IPropertyChangeListener {
    public CommitAction(ISynchronizePageConfiguration configuration) {
        super(configuration);
        configuration.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setId("org.eclipse.team.cvs.ui.commit");
        this.setActionDefinitionId("org.eclipse.team.cvs.ui.commit");
    }

    protected String getBundleKeyPrefix() {
        return "WorkspaceCommitAction.";
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        return this.internalIsEnabled(selection);
    }

    private boolean internalIsEnabled(IStructuredSelection selection) {
        int mode = this.getConfiguration().getMode();
        if (mode == 2 || mode == 4) {
            return this.getResourceMappings(selection).length > 0;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.getConfiguration() && event.getProperty() == "org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE") {
            this.setEnabled(this.internalIsEnabled(this.getStructuredSelection()));
        }
    }

    protected ResourceTraversal[] getCommitTraversals(IStructuredSelection selection, IProgressMonitor monitor) throws CoreException {
        return this.getResourceTraversals(selection, monitor);
    }

    protected IStructuredSelection getActualSelection() throws CVSException {
        IStructuredSelection actualSelection;
        IStructuredSelection selection = this.getStructuredSelection();
        if (!this.equal(selection, actualSelection = this.internalGetActualSelection())) {
            throw new CVSException(CVSUIMessages.CommitAction_3);
        }
        return selection;
    }

    private boolean equal(IStructuredSelection selection, IStructuredSelection actualSelection) {
        return selection.equals(actualSelection);
    }

    private IStructuredSelection internalGetActualSelection() {
        ISelection s = this.getConfiguration().getSite().getSelectionProvider().getSelection();
        if (s instanceof IStructuredSelection) {
            return (IStructuredSelection)s;
        }
        return StructuredSelection.EMPTY;
    }
}

