/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;

    public TabItem(TabFolder parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            TabItem.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return new Rectangle(0, 0, 0, 0);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        int index = this.parent.indexOf(this);
        if (index == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.toolTipText = null;
    }

    public void setControl(Control control) {
        int selectionIndex;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                TabItem.error(5);
            }
            if (control.parent != this.parent) {
                TabItem.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != (selectionIndex = this.parent.getSelectionIndex()) && newControl != null) {
            Control selectedControl;
            if (selectionIndex != -1 && (selectedControl = this.parent.getItem(selectionIndex).getControl()) == newControl) {
                return;
            }
            newControl.setVisible(false);
            return;
        }
        if (newControl != null) {
            newControl.setBounds(this.parent.getClientArea());
            newControl.setVisible(true);
        }
        if (oldControl != null) {
            oldControl.setVisible(false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            TabItem.error(4);
        }
        super.setText(string);
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        this.fixMnemonic(text);
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        int index = this.parent.indexOf(this);
        int[] nArray = new int[3];
        nArray[0] = 64002;
        int[] args = nArray;
        OS.PtGetResources(this.parent.handle, args.length / 3, args);
        int count = args[2];
        int oldPtr = args[1];
        int newPtr = OS.malloc(count * 4);
        int[] str = new int[1];
        int[] address = new int[1];
        int i = 0;
        while (i < count) {
            if (i == index) {
                str[0] = OS.malloc(buffer.length);
                OS.memmove(str[0], buffer, buffer.length);
            } else {
                OS.memmove(address, oldPtr + i * 4, 4);
                str[0] = OS.strdup(address[0]);
            }
            OS.memmove(newPtr + i * 4, str, 4);
            ++i;
        }
        OS.PtSetResource(this.parent.handle, 64002, newPtr, count);
        i = 0;
        while (i < count) {
            OS.memmove(address, newPtr + i * 4, 4);
            OS.free(address[0]);
            ++i;
        }
        OS.free(newPtr);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

