/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhEvent_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.internal.photon.PhPointerEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    static final int INCREMENT = 1;
    static final int PAGE_INCREMENT = 9;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Sash.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Sash.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 3;
        } else {
            width += 3;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 0x88;
        int clazz = this.display.PtContainer;
        int parentHandle = this.parent.parentingHandle();
        int cursor = (this.style & 0x100) != 0 ? 59664 : 59666;
        int[] nArray = new int[9];
        nArray[0] = 1006;
        nArray[2] = 1024;
        nArray[3] = 1002;
        nArray[4] = cursor;
        nArray[6] = 1008;
        nArray[8] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            Sash.error(2);
        }
    }

    byte[] defaultFont() {
        return this.display.TITLE_FONT;
    }

    void drawBand(int x, int y, int width, int height) {
        if (this.parent == null) {
            return;
        }
        if (this.parent.isDisposed()) {
            return;
        }
        int parentHandle = this.parent.handle;
        if (!OS.PtWidgetIsRealized(parentHandle)) {
            return;
        }
        int phGC = OS.PgCreateGC(0);
        if (phGC == 0) {
            return;
        }
        int[] nArray = new int[6];
        nArray[0] = 2001;
        nArray[3] = 2002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int foreground = args[1];
        int background = args[4];
        int color = foreground ^ ~background;
        int prevContext = OS.PgSetGC(phGC);
        int disjoint = OS.PtFindDisjoint(this.handle);
        if (disjoint != 0) {
            OS.PgSetRegion(OS.PtWidgetRid(disjoint));
        }
        PhPoint_t pt = new PhPoint_t();
        if (parentHandle <= 0) {
            return;
        }
        OS.PtWidgetOffset(parentHandle, pt);
        OS.PgSetTranslation(pt, 0);
        OS.PgSetDrawMode(26240);
        OS.PgSetFillColor(color);
        OS.PgDrawIRect(x, y, x + width - 1, y + height - 1, 32);
        OS.PgSetGC(prevContext);
        OS.PgDestroyGC(phGC);
    }

    int Ph_EV_BUT_PRESS(int widget, int info) {
        int result = super.Ph_EV_BUT_PRESS(widget, info);
        if (result != 0) {
            return result;
        }
        this.processMouse(info);
        return result;
    }

    int Ph_EV_BUT_RELEASE(int widget, int info) {
        int result = super.Ph_EV_BUT_RELEASE(widget, info);
        if (result != 0) {
            return result;
        }
        this.processMouse(info);
        return result;
    }

    int Ph_EV_DRAG(int widget, int info) {
        int result = super.Ph_EV_DRAG(widget, info);
        if (result != 0) {
            return result;
        }
        this.processMouse(info);
        return result;
    }

    int Ph_EV_PTR_MOTION(int widget, int info) {
        int result = super.Ph_EV_PTR_MOTION(widget, info);
        if (result != 0) {
            return result;
        }
        this.processMouse(info);
        return result;
    }

    void processMouse(int info) {
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        PhEvent_t ev = new PhEvent_t();
        OS.memmove(ev, cbinfo.event, 40);
        int data = OS.PhGetData(cbinfo.event);
        PhPointerEvent_t pe = new PhPointerEvent_t();
        OS.memmove(pe, data, 20);
        if (pe.buttons != 4) {
            return;
        }
        int x = pe.pos_x + ev.translation_x;
        int y = pe.pos_y + ev.translation_y;
        PhArea_t area = new PhArea_t();
        OS.PtWidgetArea(this.handle, area);
        Event event = new Event();
        short s = area.size_w;
        event.width = s;
        short width = s;
        short s2 = area.size_h;
        event.height = s2;
        short height = s2;
        switch (ev.type) {
            case 2: {
                PhRect_t rect = new PhRect_t();
                PhPoint_t pos = new PhPoint_t();
                pos.x = pe.pos_x;
                pos.y = pe.pos_y;
                rect.ul_x = rect.lr_x = (short)(pos.x + ev.translation_x);
                rect.ul_y = rect.lr_y = (short)(pos.y + ev.translation_y);
                int rid = OS.PtWidgetRid(this.handle);
                int input_group = OS.PhInputGroup(0);
                OS.PhInitDrag(rid, 63, rect, null, input_group, null, null, null, pos, null);
                this.startX = x;
                this.startY = y;
                this.lastX = area.pos_x;
                this.lastY = area.pos_y;
                event.x = this.lastX;
                event.y = this.lastY;
                event.detail = 1;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return;
                }
                if (!event.doit) break;
                this.dragging = true;
                this.menuShell().bringToTop(true);
                OS.PtFlush();
                this.lastX = event.x;
                this.lastY = event.y;
                this.drawBand(this.lastX, this.lastY, width, height);
                break;
            }
            case 4: {
                if (ev.subtype != 1) {
                    return;
                }
                if (!this.dragging) {
                    return;
                }
                this.dragging = false;
                event.x = this.lastX;
                event.y = this.lastY;
                this.drawBand(this.lastX, this.lastY, width, height);
                this.sendEvent(13, event);
                break;
            }
            case 8: 
            case 16: 
            case 512: {
                if (ev.subtype != 4) {
                    return;
                }
                if (!this.dragging) {
                    return;
                }
                x += area.pos_x;
                y += area.pos_y;
                Rectangle r = this.parent.getClientArea();
                int clientWidth = r.width;
                int clientHeight = r.height;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, x - this.startX), clientWidth - width);
                } else {
                    newY = Math.min(Math.max(0, y - this.startY), clientHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return;
                }
                this.drawBand(this.lastX, this.lastY, width, height);
                event.x = newX;
                event.y = newY;
                event.detail = 1;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return;
                }
                if (!event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                OS.PtFlush();
                this.drawBand(this.lastX, this.lastY, width, height);
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Sash.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int traversalCode(int key_sym, PhKeyEvent_t ke) {
        return 0;
    }

    boolean translateTraversal(int key_sym, PhKeyEvent_t phEvent) {
        boolean result = super.translateTraversal(key_sym, phEvent);
        if (!result) {
            switch (key_sym) {
                case 61521: 
                case 61522: 
                case 61523: 
                case 61524: {
                    if ((phEvent.button_state & 4) != 0) {
                        return result;
                    }
                    int step = (phEvent.key_mods & 2) != 0 ? 1 : 9;
                    int x = 0;
                    int y = 0;
                    if ((this.style & 0x200) != 0) {
                        if (key_sym == 61522 || key_sym == 61524) break;
                        x = key_sym == 61521 ? -step : step;
                    } else {
                        if (key_sym == 61521 || key_sym == 61523) break;
                        y = key_sym == 61522 ? -step : step;
                    }
                    PhArea_t area = new PhArea_t();
                    OS.PtWidgetArea(this.handle, area);
                    x += area.pos_x;
                    y += area.pos_y;
                    short width = area.size_w;
                    short height = area.size_h;
                    Rectangle r = this.parent.getClientArea();
                    int clientWidth = r.width;
                    int clientHeight = r.height;
                    int newX = this.lastX;
                    int newY = this.lastY;
                    if ((this.style & 0x200) != 0) {
                        newX = Math.min(Math.max(0, x - this.startX), clientWidth - width);
                    } else {
                        newY = Math.min(Math.max(0, y - this.startY), clientHeight - height);
                    }
                    if (newX == this.lastX && newY == this.lastY) {
                        return result;
                    }
                    Event event = new Event();
                    event.x = newX;
                    event.y = newY;
                    event.width = width;
                    event.height = height;
                    this.sendEvent(13, event);
                    if (this.isDisposed()) {
                        return true;
                    }
                    if (event.doit) {
                        OS.PtWidgetArea(this.handle, area);
                        int cursorX = area.size_w / 2;
                        int cursorY = area.size_h / 2;
                        short[] absX = new short[1];
                        short[] absY = new short[1];
                        OS.PtGetAbsPosition(this.handle, absX, absY);
                        OS.PhMoveCursorAbs(OS.PhInputGroup(0), cursorX + absX[0], cursorY + absY[0]);
                    }
                    return result;
                }
            }
        }
        return result;
    }

    int widgetClass() {
        return OS.PtContainer();
    }
}

