/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;
    static final int TEXT_INSET = 6;
    static final int BORDER = 1;
    static final int CHEVRON_SIZE = 24;

    public ExpandItem(ExpandBar parent, int style) {
        this(parent, style, ExpandItem.checkNull(parent).getItemCount());
    }

    public ExpandItem(ExpandBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, style, index);
    }

    static ExpandBar checkNull(ExpandBar control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
    }

    void drawChevron(GC gc, int x, int y) {
        int[] polyline2;
        int[] polyline1;
        if (this.expanded) {
            int px = x + 4 + 5;
            int py = y + 4 + 7;
            polyline1 = new int[]{px, py, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 6, py};
            polyline2 = new int[]{px, py += 4, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 6, py};
        } else {
            int px = x + 4 + 5;
            int py = y + 4 + 4;
            polyline1 = new int[]{px, py, px + 1, py, px + 1, py + 1, px + 2, py + 1, px + 2, py + 2, px + 3, py + 2, px + 3, py + 3, px + 3, py + 2, px + 4, py + 2, px + 4, py + 1, px + 5, py + 1, px + 5, py, px + 6, py};
            polyline2 = new int[]{px, py += 4, px + 1, py, px + 1, py + 1, px + 2, py + 1, px + 2, py + 2, px + 3, py + 2, px + 3, py + 3, px + 3, py + 2, px + 4, py + 2, px + 4, py + 1, px + 5, py + 1, px + 5, py, px + 6, py};
        }
        gc.setForeground(this.display.getSystemColor(30));
        gc.drawPolyline(polyline1);
        gc.drawPolyline(polyline2);
    }

    void drawItem(GC gc, boolean drawFocus) {
        int headerHeight = this.parent.getBandHeight();
        Display display = this.getDisplay();
        gc.setForeground(display.getSystemColor(31));
        gc.setBackground(display.getSystemColor(32));
        gc.fillGradientRectangle(this.x, this.y, this.width, headerHeight, true);
        if (this.expanded) {
            gc.setForeground(display.getSystemColor(32));
            gc.drawLine(this.x, this.y + headerHeight, this.x, this.y + headerHeight + this.height - 1);
            gc.drawLine(this.x, this.y + headerHeight + this.height - 1, this.x + this.width - 1, this.y + headerHeight + this.height - 1);
            gc.drawLine(this.x + this.width - 1, this.y + headerHeight + this.height - 1, this.x + this.width - 1, this.y + headerHeight);
        }
        int drawX = this.x;
        if (this.image != null) {
            drawX += 6;
            if (this.imageHeight > headerHeight) {
                gc.drawImage(this.image, drawX, this.y + headerHeight - this.imageHeight);
            } else {
                gc.drawImage(this.image, drawX, this.y + (headerHeight - this.imageHeight) / 2);
            }
            drawX += this.imageWidth;
        }
        if (this.text.length() > 0) {
            Point size = gc.stringExtent(this.text);
            gc.setForeground(this.parent.getForeground());
            gc.drawString(this.text, drawX += 6, this.y + (headerHeight - size.y) / 2, true);
        }
        int chevronSize = 24;
        this.drawChevron(gc, this.x + this.width - chevronSize, this.y + (headerHeight - chevronSize) / 2);
        if (drawFocus) {
            gc.drawFocus(this.x + 1, this.y + 1, this.width - 2, headerHeight - 2);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return Math.max(this.parent.getBandHeight(), this.imageHeight);
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(GC gc) {
        int width = 36;
        if (this.image != null) {
            width += 6 + this.imageWidth;
        }
        if (this.text.length() > 0) {
            width += gc.stringExtent((String)this.text).x;
        }
        return width;
    }

    void redraw() {
        int headerHeight = this.parent.getBandHeight();
        if (this.imageHeight > headerHeight) {
            this.parent.redraw(this.x + 6, this.y + headerHeight - this.imageHeight, this.imageWidth, this.imageHeight, false);
        }
        this.parent.redraw(this.x, this.y, this.width, headerHeight + this.height, false);
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean size) {
        this.redraw();
        int headerHeight = this.parent.getBandHeight();
        if (move) {
            if (this.imageHeight > headerHeight) {
                y += this.imageHeight - headerHeight;
            }
            this.x = x;
            this.y = y;
            this.redraw();
        }
        if (size) {
            this.width = width;
            this.height = height;
            this.redraw();
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (move) {
                this.control.setLocation(x + 1, y + headerHeight);
            }
            if (size) {
                this.control.setSize(Math.max(0, width - 2), Math.max(0, height - 1));
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                ExpandItem.error(5);
            }
            if (control.parent != this.parent) {
                ExpandItem.error(32);
            }
        }
        this.control = control;
        if (control != null) {
            control.setVisible(this.expanded);
            int headerHeight = this.parent.getBandHeight();
            control.setBounds(this.x + 1, this.y + headerHeight, Math.max(0, this.width - 2), Math.max(0, this.height - 1));
        }
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        this.parent.showItem(this);
    }

    public void setImage(Image image) {
        super.setImage(image);
        int oldImageHeight = this.imageHeight;
        if (image != null) {
            Rectangle bounds = image.getBounds();
            this.imageHeight = bounds.height;
            this.imageWidth = bounds.width;
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        if (oldImageHeight != this.imageHeight) {
            this.parent.layoutItems(this.parent.indexOf(this), true);
        } else {
            this.redraw();
        }
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height < 0) {
            return;
        }
        this.setBounds(0, 0, this.width, height, false, true);
        if (this.expanded) {
            this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.redraw();
    }
}

